/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginLoggerContext;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.springframework.boot.logging.log4j2.ElasticCommonSchemaStructuredLogFormatter;
import org.springframework.boot.logging.log4j2.GraylogExtendedLogFormatStructuredLogFormatter;
import org.springframework.boot.logging.log4j2.Log4J2LoggingSystem;
import org.springframework.boot.logging.log4j2.LogstashStructuredLogFormatter;
import org.springframework.boot.logging.structured.CommonStructuredLogFormat;
import org.springframework.boot.logging.structured.StructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLogFormatterFactory;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.boot.util.Instantiator;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

@Plugin(name="StructuredLogLayout", category="Core", elementType="layout")
final class StructuredLogLayout
extends AbstractStringLayout {
    private final StructuredLogFormatter<LogEvent> formatter;

    private StructuredLogLayout(Charset charset, StructuredLogFormatter<LogEvent> formatter) {
        super(charset);
        Assert.notNull(formatter, "Formatter must not be null");
        this.formatter = formatter;
    }

    public String toSerializable(LogEvent event) {
        return this.formatter.format(event);
    }

    public byte[] toByteArray(LogEvent event) {
        return this.formatter.formatAsBytes(event, this.getCharset() != null ? this.getCharset() : StandardCharsets.UTF_8);
    }

    @PluginBuilderFactory
    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder
    implements org.apache.logging.log4j.core.util.Builder<StructuredLogLayout> {
        @PluginLoggerContext
        private LoggerContext loggerContext;
        @PluginBuilderAttribute
        private String format;
        @PluginBuilderAttribute
        private String charset = StandardCharsets.UTF_8.name();

        Builder() {
        }

        Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public StructuredLogLayout build() {
            Charset charset = Charset.forName(this.charset);
            Environment environment2 = Log4J2LoggingSystem.getEnvironment(this.loggerContext);
            Assert.state(environment2 != null, "Unable to find Spring Environment in logger context");
            StructuredLogFormatter<LogEvent> formatter = new StructuredLogFormatterFactory<LogEvent>(LogEvent.class, environment2, null, this::addCommonFormatters).get(this.format);
            return new StructuredLogLayout(charset, formatter);
        }

        private void addCommonFormatters(StructuredLogFormatterFactory.CommonFormatters<LogEvent> commonFormatters) {
            commonFormatters.add(CommonStructuredLogFormat.ELASTIC_COMMON_SCHEMA, this::createEcsFormatter);
            commonFormatters.add(CommonStructuredLogFormat.GRAYLOG_EXTENDED_LOG_FORMAT, this::createGraylogFormatter);
            commonFormatters.add(CommonStructuredLogFormat.LOGSTASH, this::createLogstashFormatter);
        }

        private ElasticCommonSchemaStructuredLogFormatter createEcsFormatter(Instantiator<?> instantiator) {
            Environment environment2 = instantiator.getArg(Environment.class);
            StructuredLoggingJsonMembersCustomizer jsonMembersCustomizer = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.class);
            return new ElasticCommonSchemaStructuredLogFormatter(environment2, jsonMembersCustomizer);
        }

        private GraylogExtendedLogFormatStructuredLogFormatter createGraylogFormatter(Instantiator<?> instantiator) {
            Environment environment2 = instantiator.getArg(Environment.class);
            StructuredLoggingJsonMembersCustomizer jsonMembersCustomizer = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.class);
            return new GraylogExtendedLogFormatStructuredLogFormatter(environment2, jsonMembersCustomizer);
        }

        private LogstashStructuredLogFormatter createLogstashFormatter(Instantiator<?> instantiator) {
            StructuredLoggingJsonMembersCustomizer jsonMembersCustomizer = instantiator.getArg(StructuredLoggingJsonMembersCustomizer.class);
            return new LogstashStructuredLogFormatter(jsonMembersCustomizer);
        }
    }
}

