/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.log4j2.StructuredMessage;
import org.springframework.boot.logging.structured.ElasticCommonSchemaProperties;
import org.springframework.boot.logging.structured.JsonWriterStructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLoggingJsonMembersCustomizer;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

class ElasticCommonSchemaStructuredLogFormatter
extends JsonWriterStructuredLogFormatter<LogEvent> {
    ElasticCommonSchemaStructuredLogFormatter(Environment environment2, StructuredLoggingJsonMembersCustomizer<?> customizer2) {
        super((JsonWriter.Members<E> members) -> ElasticCommonSchemaStructuredLogFormatter.jsonMembers(environment2, members), customizer2);
    }

    private static void jsonMembers(Environment environment2, JsonWriter.Members<LogEvent> members) {
        members.add("@timestamp", LogEvent::getInstant).as(ElasticCommonSchemaStructuredLogFormatter::asTimestamp);
        members.add("log.level", LogEvent::getLevel).as(Level::name);
        members.add("process.pid", environment2.getProperty("spring.application.pid", Long.class)).when(Objects::nonNull);
        members.add("process.thread.name", LogEvent::getThreadName);
        ElasticCommonSchemaProperties.get(environment2).jsonMembers(members);
        members.add("log.logger", LogEvent::getLoggerName);
        members.add("message", LogEvent::getMessage).as(StructuredMessage::get);
        members.from(LogEvent::getContextData).whenNot(ReadOnlyStringMap::isEmpty).usingPairs((contextData, pairs) -> contextData.forEach(pairs::accept));
        members.from(LogEvent::getThrownProxy).whenNotNull().usingMembers(thrownProxyMembers -> {
            thrownProxyMembers.add("error.type", ThrowableProxy::getThrowable).whenNotNull().as(ObjectUtils::nullSafeClassName);
            thrownProxyMembers.add("error.message", ThrowableProxy::getMessage);
            thrownProxyMembers.add("error.stack_trace", ThrowableProxy::getExtendedStackTraceAsString);
        });
        members.add("ecs.version", "8.11");
    }

    private static java.time.Instant asTimestamp(Instant instant) {
        return java.time.Instant.ofEpochMilli(instant.getEpochMillisecond()).plusNanos(instant.getNanoOfMillisecond());
    }
}

