/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import org.apache.commons.logging.Log;

public enum LogLevel {
    TRACE(Log::trace),
    DEBUG(Log::debug),
    INFO(Log::info),
    WARN(Log::warn),
    ERROR(Log::error),
    FATAL(Log::fatal),
    OFF(null);

    private final LogMethod logMethod;

    private LogLevel(LogMethod logMethod) {
        this.logMethod = logMethod;
    }

    public void log(Log logger, Object message2) {
        this.log(logger, message2, null);
    }

    public void log(Log logger, Object message2, Throwable cause) {
        if (logger != null && this.logMethod != null) {
            this.logMethod.log(logger, message2, cause);
        }
    }

    @FunctionalInterface
    private static interface LogMethod {
        public void log(Log var1, Object var2, Throwable var3);
    }
}

