/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.json.AbstractJsonParser;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicJsonParser
extends AbstractJsonParser {
    private static final int MAX_DEPTH = 1000;

    @Override
    public Map<String, Object> parseMap(String json) {
        return this.tryParse(() -> this.parseMap(json, jsonToParse -> this.parseMapInternal(0, (String)jsonToParse)), Exception.class);
    }

    @Override
    public List<Object> parseList(String json) {
        return this.tryParse(() -> this.parseList(json, jsonToParse -> this.parseListInternal(0, (String)jsonToParse)), Exception.class);
    }

    private List<Object> parseListInternal(int nesting, String json) {
        ArrayList<Object> list = new ArrayList<Object>();
        json = BasicJsonParser.trimEdges(json, '[', ']').trim();
        for (String value : this.tokenize(json)) {
            list.add(this.parseInternal(nesting + 1, value));
        }
        return list;
    }

    private Object parseInternal(int nesting, String json) {
        if (nesting > 1000) {
            throw new IllegalStateException("JSON is too deeply nested");
        }
        if (json.startsWith("[")) {
            return this.parseListInternal(nesting + 1, json);
        }
        if (json.startsWith("{")) {
            return this.parseMapInternal(nesting + 1, json);
        }
        if (json.startsWith("\"")) {
            return BasicJsonParser.trimEdges(json, '\"', '\"');
        }
        return this.parseNumber(json);
    }

    private Map<String, Object> parseMapInternal(int nesting, String json) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        json = BasicJsonParser.trimEdges(json, '{', '}').trim();
        for (String pair : this.tokenize(json)) {
            String[] values2 = StringUtils.trimArrayElements(StringUtils.split(pair, ":"));
            Assert.state(values2[0].startsWith("\"") && values2[0].endsWith("\""), "Expecting double-quotes around field names");
            String key = BasicJsonParser.trimEdges(values2[0], '\"', '\"');
            Object value = this.parseInternal(nesting, values2[1]);
            map.put(key, value);
        }
        return map;
    }

    private Object parseNumber(String json) {
        try {
            return Long.valueOf(json);
        }
        catch (NumberFormatException ex) {
            try {
                return Double.valueOf(json);
            }
            catch (NumberFormatException ex2) {
                return json;
            }
        }
    }

    private static String trimTrailingCharacter(String string, char c) {
        if (!string.isEmpty() && string.charAt(string.length() - 1) == c) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String trimLeadingCharacter(String string, char c) {
        if (!string.isEmpty() && string.charAt(0) == c) {
            return string.substring(1);
        }
        return string;
    }

    private static String trimEdges(String string, char leadingChar, char trailingChar) {
        return BasicJsonParser.trimTrailingCharacter(BasicJsonParser.trimLeadingCharacter(string, leadingChar), trailingChar);
    }

    private List<String> tokenize(String json) {
        ArrayList<String> list = new ArrayList<String>();
        Tracking tracking = new Tracking();
        StringBuilder build = new StringBuilder();
        int index = 0;
        while (index < json.length()) {
            char ch = json.charAt(index);
            if (tracking.in(Tracked.ESCAPE)) {
                build.append(ch);
                ++index;
                tracking.set(Tracked.ESCAPE, 0);
                continue;
            }
            switch (ch) {
                case '{': {
                    tracking.update(Tracked.OBJECT, 1);
                    break;
                }
                case '}': {
                    tracking.update(Tracked.OBJECT, -1);
                    break;
                }
                case '[': {
                    tracking.update(Tracked.LIST, 1);
                    break;
                }
                case ']': {
                    tracking.update(Tracked.LIST, -1);
                    break;
                }
                case '\"': {
                    tracking.toggle(Tracked.VALUE);
                }
            }
            if (ch == ',' && !tracking.in(Tracked.OBJECT, Tracked.LIST, Tracked.VALUE)) {
                list.add(build.toString());
                build.setLength(0);
            } else if (ch == '\\') {
                tracking.set(Tracked.ESCAPE, 1);
            } else {
                build.append(ch);
            }
            ++index;
        }
        if (!build.isEmpty()) {
            list.add(build.toString().trim());
        }
        return list;
    }

    private static final class Tracking {
        private final int[] counts = new int[Tracked.values().length];

        private Tracking() {
        }

        boolean in(Tracked ... tracked) {
            return Arrays.stream(tracked).mapToInt(this::get).anyMatch(i2 -> i2 > 0);
        }

        void toggle(Tracked tracked) {
            this.set(tracked, this.get(tracked) != 0 ? 0 : 1);
        }

        void update(Tracked tracked, int delta) {
            this.set(tracked, this.get(tracked) + delta);
        }

        private int get(Tracked tracked) {
            return this.counts[tracked.ordinal()];
        }

        void set(Tracked tracked, int count) {
            this.counts[tracked.ordinal()] = count;
        }
    }

    private static enum Tracked {
        OBJECT,
        LIST,
        VALUE,
        ESCAPE;

    }
}

