/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import io.netty.handler.ssl.SslContextBuilder;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.net.ssl.SSLException;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslManagerBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.ReactorClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.function.ThrowingConsumer;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.SslProvider;

public final class ReactorClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<ReactorClientHttpRequestFactory> {
    private final UnaryOperator<HttpClient> httpClientCustomizer;

    ReactorClientHttpRequestFactoryBuilder() {
        this(null, UnaryOperator.identity());
    }

    private ReactorClientHttpRequestFactoryBuilder(List<Consumer<ReactorClientHttpRequestFactory>> customizers, UnaryOperator<HttpClient> httpClientCustomizer) {
        super(customizers);
        this.httpClientCustomizer = httpClientCustomizer;
    }

    public ReactorClientHttpRequestFactoryBuilder withCustomizer(Consumer<ReactorClientHttpRequestFactory> customizer2) {
        return new ReactorClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer2), this.httpClientCustomizer);
    }

    public ReactorClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<ReactorClientHttpRequestFactory>> customizers) {
        return new ReactorClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientCustomizer);
    }

    public ReactorClientHttpRequestFactoryBuilder withHttpClientCustomizer(UnaryOperator<HttpClient> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, "'httpClientCustomizer' must not be null");
        return new ReactorClientHttpRequestFactoryBuilder(this.getCustomizers(), t -> (HttpClient)httpClientCustomizer.apply((HttpClient)this.httpClientCustomizer.apply((HttpClient)t)));
    }

    @Override
    protected ReactorClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        ReactorClientHttpRequestFactory requestFactory = this.createRequestFactory(settings);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).asInt(Duration::toMillis).to(requestFactory::setConnectTimeout);
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(requestFactory::setReadTimeout);
        return requestFactory;
    }

    private ReactorClientHttpRequestFactory createRequestFactory(ClientHttpRequestFactorySettings settings) {
        HttpClient httpClient = this.applyDefaults(HttpClient.create());
        httpClient = httpClient.followRedirect(this.followRedirects(settings.redirects()));
        if (settings.sslBundle() != null) {
            httpClient = httpClient.secure(ThrowingConsumer.of((T spec) -> this.configureSsl((SslProvider.SslContextSpec)spec, settings.sslBundle())));
        }
        httpClient = (HttpClient)this.httpClientCustomizer.apply(httpClient);
        return new ReactorClientHttpRequestFactory(httpClient);
    }

    private boolean followRedirects(ClientHttpRequestFactorySettings.Redirects redirects) {
        return switch (redirects) {
            default -> throw new IncompatibleClassChangeError();
            case ClientHttpRequestFactorySettings.Redirects.FOLLOW_WHEN_POSSIBLE, ClientHttpRequestFactorySettings.Redirects.FOLLOW -> true;
            case ClientHttpRequestFactorySettings.Redirects.DONT_FOLLOW -> false;
        };
    }

    HttpClient applyDefaults(HttpClient httpClient) {
        return httpClient.compress(true);
    }

    private void configureSsl(SslProvider.SslContextSpec spec, SslBundle sslBundle) throws SSLException {
        SslOptions options = sslBundle.getOptions();
        SslManagerBundle managers = sslBundle.getManagers();
        SslContextBuilder builder = SslContextBuilder.forClient().keyManager(managers.getKeyManagerFactory()).trustManager(managers.getTrustManagerFactory()).ciphers(SslOptions.asSet(options.getCiphers())).protocols(options.getEnabledProtocols());
        spec.sslContext(builder.build());
    }

    static class Classes {
        static final String HTTP_CLIENT = "reactor.netty.http.client.HttpClient";
        static final boolean PRESENT = ClassUtils.isPresent("reactor.netty.http.client.HttpClient", null);

        Classes() {
        }
    }
}

