/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.client.transport.HttpClientTransportOverHTTP;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.http.client.JettyClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class JettyClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<JettyClientHttpRequestFactory> {
    private final Consumer<HttpClient> httpClientCustomizer;
    private final Consumer<HttpClientTransport> httpClientTransportCustomizer;
    private final Consumer<ClientConnector> clientConnectorCustomizerCustomizer;

    JettyClientHttpRequestFactoryBuilder() {
        this(null, JettyClientHttpRequestFactoryBuilder.emptyCustomizer(), JettyClientHttpRequestFactoryBuilder.emptyCustomizer(), JettyClientHttpRequestFactoryBuilder.emptyCustomizer());
    }

    private JettyClientHttpRequestFactoryBuilder(List<Consumer<JettyClientHttpRequestFactory>> customizers, Consumer<HttpClient> httpClientCustomizer, Consumer<HttpClientTransport> httpClientTransportCustomizer, Consumer<ClientConnector> clientConnectorCustomizerCustomizer) {
        super(customizers);
        this.httpClientCustomizer = httpClientCustomizer;
        this.httpClientTransportCustomizer = httpClientTransportCustomizer;
        this.clientConnectorCustomizerCustomizer = clientConnectorCustomizerCustomizer;
    }

    public JettyClientHttpRequestFactoryBuilder withCustomizer(Consumer<JettyClientHttpRequestFactory> customizer2) {
        return new JettyClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer2), this.httpClientCustomizer, this.httpClientTransportCustomizer, this.clientConnectorCustomizerCustomizer);
    }

    public JettyClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<JettyClientHttpRequestFactory>> customizers) {
        return new JettyClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientCustomizer, this.httpClientTransportCustomizer, this.clientConnectorCustomizerCustomizer);
    }

    public JettyClientHttpRequestFactoryBuilder withHttpClientCustomizer(Consumer<HttpClient> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, "'httpClientCustomizer' must not be null");
        return new JettyClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer.andThen(httpClientCustomizer), this.httpClientTransportCustomizer, this.clientConnectorCustomizerCustomizer);
    }

    public JettyClientHttpRequestFactoryBuilder withHttpClientTransportCustomizer(Consumer<HttpClientTransport> httpClientTransportCustomizer) {
        Assert.notNull(httpClientTransportCustomizer, "'httpClientTransportCustomizer' must not be null");
        return new JettyClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer, this.httpClientTransportCustomizer.andThen(httpClientTransportCustomizer), this.clientConnectorCustomizerCustomizer);
    }

    public JettyClientHttpRequestFactoryBuilder withClientConnectorCustomizerCustomizer(Consumer<ClientConnector> clientConnectorCustomizerCustomizer) {
        Assert.notNull(clientConnectorCustomizerCustomizer, "'clientConnectorCustomizerCustomizer' must not be null");
        return new JettyClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientCustomizer, this.httpClientTransportCustomizer, this.clientConnectorCustomizerCustomizer.andThen(clientConnectorCustomizerCustomizer));
    }

    @Override
    protected JettyClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        JettyClientHttpRequestFactory requestFactory = this.createRequestFactory(settings);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::connectTimeout).asInt(Duration::toMillis).to(requestFactory::setConnectTimeout);
        map.from(settings::readTimeout).asInt(Duration::toMillis).to(requestFactory::setReadTimeout);
        return requestFactory;
    }

    private JettyClientHttpRequestFactory createRequestFactory(ClientHttpRequestFactorySettings settings) {
        HttpClientTransport transport = this.createTransport(settings);
        this.httpClientTransportCustomizer.accept(transport);
        HttpClient httpClient = new HttpClient(transport);
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(settings::redirects).as(this::followRedirects).to(arg_0 -> ((HttpClient)httpClient).setFollowRedirects(arg_0));
        this.httpClientCustomizer.accept(httpClient);
        return new JettyClientHttpRequestFactory(httpClient);
    }

    private HttpClientTransport createTransport(ClientHttpRequestFactorySettings settings) {
        ClientConnector connector = this.createClientConnector(settings.sslBundle());
        return connector.getSslContextFactory() != null ? new HttpClientTransportDynamic(connector, new ClientConnectionFactory.Info[0]) : new HttpClientTransportOverHTTP(connector);
    }

    private ClientConnector createClientConnector(SslBundle sslBundle) {
        ClientConnector connector = new ClientConnector();
        if (sslBundle != null) {
            connector.setSslContextFactory(this.createSslContextFactory(sslBundle));
        }
        this.clientConnectorCustomizerCustomizer.accept(connector);
        return connector;
    }

    private SslContextFactory.Client createSslContextFactory(SslBundle sslBundle) {
        SslOptions options = sslBundle.getOptions();
        SSLContext sslContext = sslBundle.createSslContext();
        SslContextFactory.Client factory = new SslContextFactory.Client();
        factory.setSslContext(sslContext);
        if (options.getCiphers() != null) {
            factory.setIncludeCipherSuites(options.getCiphers());
            factory.setExcludeCipherSuites(new String[0]);
        }
        if (options.getEnabledProtocols() != null) {
            factory.setIncludeProtocols(options.getEnabledProtocols());
            factory.setExcludeProtocols(new String[0]);
        }
        return factory;
    }

    private boolean followRedirects(ClientHttpRequestFactorySettings.Redirects redirects) {
        return switch (redirects) {
            default -> throw new IncompatibleClassChangeError();
            case ClientHttpRequestFactorySettings.Redirects.FOLLOW_WHEN_POSSIBLE, ClientHttpRequestFactorySettings.Redirects.FOLLOW -> true;
            case ClientHttpRequestFactorySettings.Redirects.DONT_FOLLOW -> false;
        };
    }

    static class Classes {
        static final String HTTP_CLIENT = "org.eclipse.jetty.client.HttpClient";
        static final boolean PRESENT = ClassUtils.isPresent("org.eclipse.jetty.client.HttpClient", null);

        Classes() {
        }
    }
}

