/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.env;

import java.util.Map;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginLookup;
import org.springframework.boot.origin.SystemEnvironmentOrigin;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.StringUtils;

public class SystemEnvironmentPropertySourceEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int DEFAULT_ORDER = -2147483644;
    private int order = -2147483644;

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment2, SpringApplication application) {
        String sourceName = "systemEnvironment";
        PropertySource<?> propertySource = environment2.getPropertySources().get(sourceName);
        if (propertySource != null) {
            this.replacePropertySource(environment2, sourceName, propertySource, application.getEnvironmentPrefix());
        }
    }

    private void replacePropertySource(ConfigurableEnvironment environment2, String sourceName, PropertySource<?> propertySource, String environmentPrefix) {
        Map originalSource = (Map)propertySource.getSource();
        OriginAwareSystemEnvironmentPropertySource source = new OriginAwareSystemEnvironmentPropertySource(sourceName, originalSource, environmentPrefix);
        environment2.getPropertySources().replace(sourceName, source);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    protected static class OriginAwareSystemEnvironmentPropertySource
    extends SystemEnvironmentPropertySource
    implements OriginLookup<String> {
        private final String prefix;

        OriginAwareSystemEnvironmentPropertySource(String name, Map<String, Object> source, String environmentPrefix) {
            super(name, source);
            this.prefix = this.determinePrefix(environmentPrefix);
        }

        private String determinePrefix(String environmentPrefix) {
            if (!StringUtils.hasText(environmentPrefix)) {
                return null;
            }
            if (environmentPrefix.endsWith(".") || environmentPrefix.endsWith("_") || environmentPrefix.endsWith("-")) {
                return environmentPrefix.substring(0, environmentPrefix.length() - 1);
            }
            return environmentPrefix;
        }

        @Override
        public boolean containsProperty(String name) {
            return super.containsProperty(name);
        }

        @Override
        public Object getProperty(String name) {
            return super.getProperty(name);
        }

        @Override
        public Origin getOrigin(String key) {
            String property = this.resolvePropertyName(key);
            if (super.containsProperty(property)) {
                return new SystemEnvironmentOrigin(property);
            }
            return null;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }
    }
}

