/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.util.ClassUtils;

public class ConfigurationPropertiesBindException
extends BeanCreationException {
    private final ConfigurationPropertiesBean bean;

    ConfigurationPropertiesBindException(ConfigurationPropertiesBean bean2, Exception cause) {
        super(bean2.getName(), ConfigurationPropertiesBindException.getMessage(bean2), cause);
        this.bean = bean2;
    }

    public Class<?> getBeanType() {
        return this.bean.getType();
    }

    public ConfigurationProperties getAnnotation() {
        return this.bean.getAnnotation();
    }

    private static String getMessage(ConfigurationPropertiesBean bean2) {
        ConfigurationProperties annotation = bean2.getAnnotation();
        StringBuilder message2 = new StringBuilder();
        message2.append("Could not bind properties to '");
        message2.append(ClassUtils.getShortName(bean2.getType())).append("' : ");
        message2.append("prefix=").append(annotation.prefix());
        message2.append(", ignoreInvalidFields=").append(annotation.ignoreInvalidFields());
        message2.append(", ignoreUnknownFields=").append(annotation.ignoreUnknownFields());
        return message2.toString();
    }
}

