/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.reactive;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.server.Cookie;
import org.springframework.context.annotation.Bean;
import org.springframework.http.ResponseCookie;
import org.springframework.util.StringUtils;
import org.springframework.web.server.session.CookieWebSessionIdResolver;
import org.springframework.web.server.session.WebSessionIdResolver;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Mono;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(value={WebSessionManager.class, Mono.class})
@EnableConfigurationProperties(value={WebFluxProperties.class, ServerProperties.class})
public class WebSessionIdResolverAutoConfiguration {
    private final ServerProperties serverProperties;

    public WebSessionIdResolverAutoConfiguration(ServerProperties serverProperties, WebFluxProperties webFluxProperties) {
        this.serverProperties = serverProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public WebSessionIdResolver webSessionIdResolver() {
        CookieWebSessionIdResolver resolver = new CookieWebSessionIdResolver();
        String cookieName = this.serverProperties.getReactive().getSession().getCookie().getName();
        if (StringUtils.hasText(cookieName)) {
            resolver.setCookieName(cookieName);
        }
        resolver.addCookieInitializer(this::initializeCookie);
        return resolver;
    }

    private void initializeCookie(ResponseCookie.ResponseCookieBuilder builder) {
        Cookie cookie = this.serverProperties.getReactive().getSession().getCookie();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(cookie::getDomain).to(builder::domain);
        map.from(cookie::getPath).to(builder::path);
        map.from(cookie::getHttpOnly).to(builder::httpOnly);
        map.from(cookie::getSecure).to(builder::secure);
        map.from(cookie::getMaxAge).to(builder::maxAge);
        map.from(cookie::getPartitioned).to(builder::partitioned);
        map.from(this.getSameSite(cookie)).to(builder::sameSite);
    }

    private String getSameSite(Cookie properties) {
        Cookie.SameSite sameSite = properties.getSameSite();
        return sameSite != null ? sameSite.attributeValue() : null;
    }
}

