/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import java.util.List;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.web.client.RestClientCustomizer;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;

public class RestClientBuilderConfigurer {
    private ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder;
    private ClientHttpRequestFactorySettings requestFactorySettings;
    private List<RestClientCustomizer> customizers;

    void setRequestFactoryBuilder(ClientHttpRequestFactoryBuilder<?> requestFactoryBuilder) {
        this.requestFactoryBuilder = requestFactoryBuilder;
    }

    void setRequestFactorySettings(ClientHttpRequestFactorySettings requestFactorySettings) {
        this.requestFactorySettings = requestFactorySettings;
    }

    void setRestClientCustomizers(List<RestClientCustomizer> customizers) {
        this.customizers = customizers;
    }

    public RestClient.Builder configure(RestClient.Builder builder) {
        ClientHttpRequestFactoryBuilder<ClientHttpRequestFactory> requestFactoryBuilder = this.requestFactoryBuilder != null ? this.requestFactoryBuilder : ClientHttpRequestFactoryBuilder.detect();
        builder.requestFactory(requestFactoryBuilder.build(this.requestFactorySettings));
        this.applyCustomizers(builder);
        return builder;
    }

    private void applyCustomizers(RestClient.Builder builder) {
        if (this.customizers != null) {
            for (RestClientCustomizer customizer2 : this.customizers) {
                customizer2.customize(builder);
            }
        }
    }
}

