/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.client;

import java.util.function.Consumer;
import org.springframework.boot.autoconfigure.web.client.RestClientSsl;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestClient;

class AutoConfiguredRestClientSsl
implements RestClientSsl {
    private final ClientHttpRequestFactoryBuilder<?> clientHttpRequestFactoryBuilder;
    private final SslBundles sslBundles;

    AutoConfiguredRestClientSsl(ClientHttpRequestFactoryBuilder<?> clientHttpRequestFactoryBuilder, SslBundles sslBundles) {
        this.clientHttpRequestFactoryBuilder = clientHttpRequestFactoryBuilder;
        this.sslBundles = sslBundles;
    }

    @Override
    public Consumer<RestClient.Builder> fromBundle(String bundleName) {
        return this.fromBundle(this.sslBundles.getBundle(bundleName));
    }

    @Override
    public Consumer<RestClient.Builder> fromBundle(SslBundle bundle) {
        return builder -> {
            ClientHttpRequestFactorySettings settings = ClientHttpRequestFactorySettings.ofSslBundle(bundle);
            Object requestFactory = this.clientHttpRequestFactoryBuilder.build(settings);
            builder.requestFactory((ClientHttpRequestFactory)requestFactory);
        };
    }
}

