/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import org.springframework.boot.autoconfigure.template.TemplateAvailabilityProvider;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ClassUtils;

public class ThymeleafTemplateAvailabilityProvider
implements TemplateAvailabilityProvider {
    @Override
    public boolean isTemplateAvailable(String view2, Environment environment2, ClassLoader classLoader, ResourceLoader resourceLoader) {
        if (ClassUtils.isPresent("org.thymeleaf.spring6.SpringTemplateEngine", classLoader)) {
            String prefix = environment2.getProperty("spring.thymeleaf.prefix", "classpath:/templates/");
            String suffix = environment2.getProperty("spring.thymeleaf.suffix", ".html");
            return resourceLoader.getResource(prefix + view2 + suffix).exists();
        }
        return false;
    }
}

