/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.lang.reflect.Type;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.GeneratedClass;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.AotBeanProcessingException;
import org.springframework.beans.factory.aot.AotException;
import org.springframework.beans.factory.aot.BeanDefinitionMethodGenerator;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.aot.BeanRegistrationsCode;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;

class BeanRegistrationsAotContribution
implements BeanFactoryInitializationAotContribution {
    private static final String BEAN_FACTORY_PARAMETER_NAME = "beanFactory";
    private static final MethodReference.ArgumentCodeGenerator argumentCodeGenerator = MethodReference.ArgumentCodeGenerator.of(DefaultListableBeanFactory.class, "beanFactory");
    private final List<Registration> registrations;

    BeanRegistrationsAotContribution(List<Registration> registrations) {
        this.registrations = registrations;
    }

    @Override
    public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
        GeneratedClass generatedClass = generationContext.getGeneratedClasses().addForFeature("BeanFactoryRegistrations", type -> {
            type.addJavadoc("Register bean definitions for the bean factory.", new Object[0]);
            type.addModifiers(Modifier.PUBLIC);
        });
        BeanRegistrationsCodeGenerator codeGenerator = new BeanRegistrationsCodeGenerator(generatedClass);
        GeneratedMethod generatedBeanDefinitionsMethod = new BeanDefinitionsRegistrationGenerator(generationContext, codeGenerator, this.registrations).generateRegisterBeanDefinitionsMethod();
        beanFactoryInitializationCode.addInitializer(generatedBeanDefinitionsMethod.toMethodReference());
        GeneratedMethod generatedAliasesMethod = codeGenerator.getMethods().add("registerAliases", this::generateRegisterAliasesMethod);
        beanFactoryInitializationCode.addInitializer(generatedAliasesMethod.toMethodReference());
        this.generateRegisterHints(generationContext.getRuntimeHints(), this.registrations);
    }

    private void generateRegisterAliasesMethod(MethodSpec.Builder method) {
        method.addJavadoc("Register the aliases.", new Object[0]);
        method.addModifiers(Modifier.PUBLIC);
        method.addParameter((Type)((Object)DefaultListableBeanFactory.class), BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
        CodeBlock.Builder code = CodeBlock.builder();
        this.registrations.forEach(registration -> {
            for (String alias : registration.aliases()) {
                code.addStatement("$L.registerAlias($S, $S)", BEAN_FACTORY_PARAMETER_NAME, registration.beanName(), alias);
            }
        });
        method.addCode(code.build());
    }

    private void generateRegisterHints(RuntimeHints runtimeHints, List<Registration> registrations) {
        registrations.forEach(registration -> {
            ReflectionHints hints = runtimeHints.reflection();
            Class<?> beanClass = registration.registeredBean.getBeanClass();
            hints.registerType(beanClass, MemberCategory.INTROSPECT_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_METHODS);
            hints.registerForInterfaces(beanClass, typeHint -> typeHint.withMembers(MemberCategory.INTROSPECT_PUBLIC_METHODS));
        });
    }

    static class BeanRegistrationsCodeGenerator
    implements BeanRegistrationsCode {
        private final GeneratedClass generatedClass;

        public BeanRegistrationsCodeGenerator(GeneratedClass generatedClass) {
            this.generatedClass = generatedClass;
        }

        @Override
        public ClassName getClassName() {
            return this.generatedClass.getName();
        }

        @Override
        public GeneratedMethods getMethods() {
            return this.generatedClass.getMethods();
        }
    }

    static final class BeanDefinitionsRegistrationGenerator {
        private final GenerationContext generationContext;
        private final BeanRegistrationsCodeGenerator codeGenerator;
        private final List<Registration> registrations;

        BeanDefinitionsRegistrationGenerator(GenerationContext generationContext, BeanRegistrationsCodeGenerator codeGenerator, List<Registration> registrations) {
            this.generationContext = generationContext;
            this.codeGenerator = codeGenerator;
            this.registrations = registrations;
        }

        GeneratedMethod generateRegisterBeanDefinitionsMethod() {
            return this.codeGenerator.getMethods().add("registerBeanDefinitions", method -> {
                method.addJavadoc("Register the bean definitions.", new Object[0]);
                method.addModifiers(Modifier.PUBLIC);
                method.addParameter((Type)((Object)DefaultListableBeanFactory.class), BeanRegistrationsAotContribution.BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
                if (this.registrations.size() <= 1000) {
                    this.generateRegisterBeanDefinitionMethods((MethodSpec.Builder)method, (Iterable<Registration>)this.registrations);
                } else {
                    CodeBlock.Builder code = CodeBlock.builder();
                    code.add("// Registration is sliced to avoid exceeding size limit\n", new Object[0]);
                    int index = 0;
                    int end = 0;
                    while (end < this.registrations.size()) {
                        int start2 = index * 1000;
                        end = Math.min(start2 + 1000, this.registrations.size());
                        GeneratedMethod sliceMethod = this.generateSliceMethod(start2, end);
                        code.addStatement(sliceMethod.toMethodReference().toInvokeCodeBlock(argumentCodeGenerator, this.codeGenerator.getClassName()));
                        ++index;
                    }
                    method.addCode(code.build());
                }
            });
        }

        private GeneratedMethod generateSliceMethod(int start2, int end) {
            String description = "Register the bean definitions from %s to %s.".formatted(start2, end - 1);
            List<Registration> slice = this.registrations.subList(start2, end);
            return this.codeGenerator.getMethods().add("registerBeanDefinitions", method -> {
                method.addJavadoc(description, new Object[0]);
                method.addModifiers(Modifier.PRIVATE);
                method.addParameter((Type)((Object)DefaultListableBeanFactory.class), BeanRegistrationsAotContribution.BEAN_FACTORY_PARAMETER_NAME, new Modifier[0]);
                this.generateRegisterBeanDefinitionMethods((MethodSpec.Builder)method, (Iterable<Registration>)slice);
            });
        }

        private void generateRegisterBeanDefinitionMethods(MethodSpec.Builder method, Iterable<Registration> registrations) {
            CodeBlock.Builder code = CodeBlock.builder();
            registrations.forEach(registration -> {
                try {
                    CodeBlock methodInvocation = this.generateBeanRegistration((Registration)registration);
                    code.addStatement("$L.registerBeanDefinition($S, $L)", BeanRegistrationsAotContribution.BEAN_FACTORY_PARAMETER_NAME, registration.beanName(), methodInvocation);
                }
                catch (AotException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new AotBeanProcessingException(registration.registeredBean, "failed to generate code for bean definition", ex);
                }
            });
            method.addCode(code.build());
        }

        private CodeBlock generateBeanRegistration(Registration registration) {
            MethodReference beanDefinitionMethod = registration.methodGenerator.generateBeanDefinitionMethod(this.generationContext, this.codeGenerator);
            return beanDefinitionMethod.toInvokeCodeBlock(MethodReference.ArgumentCodeGenerator.none(), this.codeGenerator.getClassName());
        }
    }

    record Registration(RegisteredBean registeredBean, BeanDefinitionMethodGenerator methodGenerator, String[] aliases) {
        String beanName() {
            return this.registeredBean.getBeanName();
        }
    }
}

