/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.aop.ClassFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class ClassFilters {
    public static ClassFilter union(ClassFilter cf1, ClassFilter cf2) {
        Assert.notNull((Object)cf1, "First ClassFilter must not be null");
        Assert.notNull((Object)cf2, "Second ClassFilter must not be null");
        return new UnionClassFilter(new ClassFilter[]{cf1, cf2});
    }

    public static ClassFilter union(ClassFilter[] classFilters) {
        Assert.notEmpty((Object[])classFilters, "ClassFilter array must not be empty");
        return new UnionClassFilter(classFilters);
    }

    public static ClassFilter intersection(ClassFilter cf1, ClassFilter cf2) {
        Assert.notNull((Object)cf1, "First ClassFilter must not be null");
        Assert.notNull((Object)cf2, "Second ClassFilter must not be null");
        return new IntersectionClassFilter(new ClassFilter[]{cf1, cf2});
    }

    public static ClassFilter intersection(ClassFilter[] classFilters) {
        Assert.notEmpty((Object[])classFilters, "ClassFilter array must not be empty");
        return new IntersectionClassFilter(classFilters);
    }

    public static ClassFilter negate(ClassFilter classFilter) {
        Assert.notNull((Object)classFilter, "ClassFilter must not be null");
        return new NegateClassFilter(classFilter);
    }

    private static class UnionClassFilter
    implements ClassFilter,
    Serializable {
        private final ClassFilter[] filters;

        UnionClassFilter(ClassFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean matches(Class<?> clazz) {
            for (ClassFilter filter2 : this.filters) {
                if (!filter2.matches(clazz)) continue;
                return true;
            }
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof UnionClassFilter)) return false;
            UnionClassFilter that = (UnionClassFilter)other;
            if (!ObjectUtils.nullSafeEquals(this.filters, that.filters)) return false;
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.filters);
        }

        public String toString() {
            return this.getClass().getName() + ": " + Arrays.toString(this.filters);
        }
    }

    private static class IntersectionClassFilter
    implements ClassFilter,
    Serializable {
        private final ClassFilter[] filters;

        IntersectionClassFilter(ClassFilter[] filters) {
            this.filters = filters;
        }

        @Override
        public boolean matches(Class<?> clazz) {
            for (ClassFilter filter2 : this.filters) {
                if (filter2.matches(clazz)) continue;
                return false;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (this == other) return true;
            if (!(other instanceof IntersectionClassFilter)) return false;
            IntersectionClassFilter that = (IntersectionClassFilter)other;
            if (!ObjectUtils.nullSafeEquals(this.filters, that.filters)) return false;
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode(this.filters);
        }

        public String toString() {
            return this.getClass().getName() + ": " + Arrays.toString(this.filters);
        }
    }

    private static class NegateClassFilter
    implements ClassFilter,
    Serializable {
        private final ClassFilter original;

        NegateClassFilter(ClassFilter original) {
            this.original = original;
        }

        @Override
        public boolean matches(Class<?> clazz) {
            return !this.original.matches(clazz);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (this == other) return true;
            if (!(other instanceof NegateClassFilter)) return false;
            NegateClassFilter that = (NegateClassFilter)other;
            if (!this.original.equals(that.original)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.original);
        }

        public String toString() {
            return "Negate " + this.original;
        }
    }
}

