/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.AopInvocationException;
import org.springframework.aop.RawTargetAccess;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.CoroutinesUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class JdkDynamicAopProxy
implements AopProxy,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 5531744639992436476L;
    private static final String COROUTINES_FLOW_CLASS_NAME = "kotlinx.coroutines.flow.Flow";
    private static final boolean coroutinesReactorPresent = ClassUtils.isPresent("kotlinx.coroutines.reactor.MonoKt", JdkDynamicAopProxy.class.getClassLoader());
    private static final Log logger = LogFactory.getLog(JdkDynamicAopProxy.class);
    private final AdvisedSupport advised;
    private transient ProxiedInterfacesCache cache;

    public JdkDynamicAopProxy(AdvisedSupport config) throws AopConfigException {
        ProxiedInterfacesCache cache;
        Assert.notNull((Object)config, "AdvisedSupport must not be null");
        this.advised = config;
        Object object = config.proxyMetadataCache;
        if (object instanceof ProxiedInterfacesCache) {
            ProxiedInterfacesCache proxiedInterfacesCache;
            cache = proxiedInterfacesCache = (ProxiedInterfacesCache)object;
        } else {
            cache = new ProxiedInterfacesCache(config);
            config.proxyMetadataCache = cache;
        }
        this.cache = cache;
    }

    @Override
    public Object getProxy() {
        return this.getProxy(ClassUtils.getDefaultClassLoader());
    }

    @Override
    public Object getProxy(@Nullable ClassLoader classLoader) {
        if (logger.isTraceEnabled()) {
            logger.trace("Creating JDK dynamic proxy: " + this.advised.getTargetSource());
        }
        return Proxy.newProxyInstance(this.determineClassLoader(classLoader), this.cache.proxiedInterfaces, (InvocationHandler)this);
    }

    @Override
    public Class<?> getProxyClass(@Nullable ClassLoader classLoader) {
        return Proxy.getProxyClass(this.determineClassLoader(classLoader), this.cache.proxiedInterfaces);
    }

    private ClassLoader determineClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return this.getClass().getClassLoader();
        }
        if (classLoader.getParent() == null) {
            ClassLoader aopClassLoader = this.getClass().getClassLoader();
            for (ClassLoader aopParent = aopClassLoader.getParent(); aopParent != null; aopParent = aopParent.getParent()) {
                if (classLoader != aopParent) continue;
                return aopClassLoader;
            }
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        Object object;
        boolean setProxyContext;
        Object oldProxy;
        block31: {
            Object retVal;
            Object target;
            TargetSource targetSource;
            block29: {
                Object object2;
                block30: {
                    Class<?> targetClass;
                    List<Object> chain;
                    block27: {
                        Object object3;
                        block28: {
                            block25: {
                                Class<?> clazz;
                                block26: {
                                    block23: {
                                        Integer n;
                                        block24: {
                                            block21: {
                                                Boolean bl;
                                                block22: {
                                                    oldProxy = null;
                                                    setProxyContext = false;
                                                    targetSource = this.advised.targetSource;
                                                    target = null;
                                                    try {
                                                        if (this.cache.equalsDefined || !AopUtils.isEqualsMethod(method)) break block21;
                                                        bl = this.equals(args2[0]);
                                                        if (target == null || targetSource.isStatic()) break block22;
                                                    }
                                                    catch (Throwable throwable) {
                                                        if (target != null && !targetSource.isStatic()) {
                                                            targetSource.releaseTarget(target);
                                                        }
                                                        if (setProxyContext) {
                                                            AopContext.setCurrentProxy(oldProxy);
                                                        }
                                                        throw throwable;
                                                    }
                                                    targetSource.releaseTarget(target);
                                                }
                                                if (setProxyContext) {
                                                    AopContext.setCurrentProxy(oldProxy);
                                                }
                                                return bl;
                                            }
                                            if (this.cache.hashCodeDefined || !AopUtils.isHashCodeMethod(method)) break block23;
                                            n = this.hashCode();
                                            if (target == null || targetSource.isStatic()) break block24;
                                            targetSource.releaseTarget(target);
                                        }
                                        if (setProxyContext) {
                                            AopContext.setCurrentProxy(oldProxy);
                                        }
                                        return n;
                                    }
                                    if (method.getDeclaringClass() != DecoratingProxy.class) break block25;
                                    clazz = AopProxyUtils.ultimateTargetClass(this.advised);
                                    if (target == null || targetSource.isStatic()) break block26;
                                    targetSource.releaseTarget(target);
                                }
                                if (setProxyContext) {
                                    AopContext.setCurrentProxy(oldProxy);
                                }
                                return clazz;
                            }
                            if (this.advised.opaque || !method.getDeclaringClass().isInterface() || !method.getDeclaringClass().isAssignableFrom(Advised.class)) break block27;
                            object3 = AopUtils.invokeJoinpointUsingReflection(this.advised, method, args2);
                            if (target == null || targetSource.isStatic()) break block28;
                            targetSource.releaseTarget(target);
                        }
                        if (setProxyContext) {
                            AopContext.setCurrentProxy(oldProxy);
                        }
                        return object3;
                    }
                    if (this.advised.exposeProxy) {
                        oldProxy = AopContext.setCurrentProxy(proxy);
                        setProxyContext = true;
                    }
                    if ((chain = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass = (target = targetSource.getTarget()) != null ? target.getClass() : null)).isEmpty()) {
                        Object[] argsToUse = AopProxyUtils.adaptArgumentsIfNecessary(method, args2);
                        retVal = AopUtils.invokeJoinpointUsingReflection(target, method, argsToUse);
                    } else {
                        ReflectiveMethodInvocation invocation = new ReflectiveMethodInvocation(proxy, target, method, args2, targetClass, chain);
                        retVal = invocation.proceed();
                    }
                    Class<?> returnType = method.getReturnType();
                    if (retVal != null && retVal == target && returnType != Object.class && returnType.isInstance(proxy) && !RawTargetAccess.class.isAssignableFrom(method.getDeclaringClass())) {
                        retVal = proxy;
                    } else if (retVal == null && returnType != Void.TYPE && returnType.isPrimitive()) {
                        throw new AopInvocationException("Null return value from advice does not match primitive return type for: " + method);
                    }
                    if (!coroutinesReactorPresent || !KotlinDetector.isSuspendingFunction(method)) break block29;
                    Object object4 = object2 = COROUTINES_FLOW_CLASS_NAME.equals(new MethodParameter(method, -1).getParameterType().getName()) ? CoroutinesUtils.asFlow(retVal) : CoroutinesUtils.awaitSingleOrNull(retVal, args2[args2.length - 1]);
                    if (target == null || targetSource.isStatic()) break block30;
                    targetSource.releaseTarget(target);
                }
                if (setProxyContext) {
                    AopContext.setCurrentProxy(oldProxy);
                }
                return object2;
            }
            object = retVal;
            if (target == null || targetSource.isStatic()) break block31;
            targetSource.releaseTarget(target);
        }
        if (setProxyContext) {
            AopContext.setCurrentProxy(oldProxy);
        }
        return object;
    }

    public boolean equals(@Nullable Object other) {
        JdkDynamicAopProxy otherProxy;
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof JdkDynamicAopProxy) {
            JdkDynamicAopProxy jdkDynamicAopProxy;
            otherProxy = jdkDynamicAopProxy = (JdkDynamicAopProxy)other;
        } else if (Proxy.isProxyClass(other.getClass())) {
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            if (!(ih instanceof JdkDynamicAopProxy)) {
                return false;
            }
            JdkDynamicAopProxy jdkDynamicAopProxy = (JdkDynamicAopProxy)ih;
            otherProxy = jdkDynamicAopProxy;
        } else {
            return false;
        }
        return AopProxyUtils.equalsInProxy(this.advised, otherProxy.advised);
    }

    public int hashCode() {
        return JdkDynamicAopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.cache = new ProxiedInterfacesCache(this.advised);
    }

    private static final class ProxiedInterfacesCache {
        final Class<?>[] proxiedInterfaces;
        final boolean equalsDefined;
        final boolean hashCodeDefined;

        ProxiedInterfacesCache(AdvisedSupport config) {
            this.proxiedInterfaces = AopProxyUtils.completeProxiedInterfaces(config, true);
            boolean equalsDefined = false;
            boolean hashCodeDefined = false;
            for (Class<?> proxiedInterface : this.proxiedInterfaces) {
                Method[] methods;
                for (Method method : methods = proxiedInterface.getDeclaredMethods()) {
                    if (AopUtils.isEqualsMethod(method)) {
                        equalsDefined = true;
                        if (hashCodeDefined) break;
                    }
                    if (!AopUtils.isHashCodeMethod(method)) continue;
                    hashCodeDefined = true;
                    if (equalsDefined) break;
                }
                if (equalsDefined && hashCodeDefined) break;
            }
            this.equalsDefined = equalsDefined;
            this.hashCodeDefined = hashCodeDefined;
        }
    }
}

