/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.NotAnAtAspectException;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.SpringProperties;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;

public abstract class AbstractAspectJAdvisorFactory
implements AspectJAdvisorFactory {
    private static final Class<?>[] ASPECTJ_ANNOTATION_CLASSES = new Class[]{Pointcut.class, Around.class, Before.class, After.class, AfterReturning.class, AfterThrowing.class};
    private static final String AJC_MAGIC = "ajc$";
    public static final String IGNORE_AJC_PROPERTY_NAME = "spring.aop.ajc.ignore";
    private static final boolean shouldIgnoreAjcCompiledAspects = SpringProperties.getFlag("spring.aop.ajc.ignore");
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final ParameterNameDiscoverer parameterNameDiscoverer = new AspectJAnnotationParameterNameDiscoverer();

    @Override
    public boolean isAspect(Class<?> clazz) {
        return AnnotationUtils.findAnnotation(clazz, Aspect.class) != null && (!shouldIgnoreAjcCompiledAspects || !AbstractAspectJAdvisorFactory.compiledByAjc(clazz));
    }

    @Override
    public void validate(Class<?> aspectClass) throws AopConfigException {
        AjType ajType = AjTypeSystem.getAjType(aspectClass);
        if (!ajType.isAspect()) {
            throw new NotAnAtAspectException(aspectClass);
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOW) {
            throw new AopConfigException(aspectClass.getName() + " uses percflow instantiation model: This is not supported in Spring AOP.");
        }
        if (ajType.getPerClause().getKind() == PerClauseKind.PERCFLOWBELOW) {
            throw new AopConfigException(aspectClass.getName() + " uses percflowbelow instantiation model: This is not supported in Spring AOP.");
        }
    }

    @Nullable
    protected static AspectJAnnotation findAspectJAnnotationOnMethod(Method method) {
        for (Class<?> annotationType : ASPECTJ_ANNOTATION_CLASSES) {
            AspectJAnnotation annotation = AbstractAspectJAdvisorFactory.findAnnotation(method, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    private static AspectJAnnotation findAnnotation(Method method, Class<? extends Annotation> annotationType) {
        Annotation annotation = AnnotationUtils.findAnnotation(method, annotationType);
        if (annotation != null) {
            return new AspectJAnnotation(annotation);
        }
        return null;
    }

    private static boolean compiledByAjc(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().startsWith(AJC_MAGIC)) continue;
            return true;
        }
        return false;
    }

    private static class AspectJAnnotationParameterNameDiscoverer
    implements ParameterNameDiscoverer {
        private static final String[] EMPTY_ARRAY = new String[0];

        private AspectJAnnotationParameterNameDiscoverer() {
        }

        @Override
        @Nullable
        public String[] getParameterNames(Method method) {
            if (method.getParameterCount() == 0) {
                return EMPTY_ARRAY;
            }
            AspectJAnnotation annotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(method);
            if (annotation == null) {
                return null;
            }
            StringTokenizer nameTokens = new StringTokenizer(annotation.getArgumentNames(), ",");
            int numTokens = nameTokens.countTokens();
            if (numTokens > 0) {
                String[] names = new String[numTokens];
                for (int i2 = 0; i2 < names.length; ++i2) {
                    names[i2] = nameTokens.nextToken();
                }
                return names;
            }
            return null;
        }

        @Override
        @Nullable
        public String[] getParameterNames(Constructor<?> ctor) {
            throw new UnsupportedOperationException("Spring AOP cannot handle constructor advice");
        }
    }

    protected static class AspectJAnnotation {
        private static final String[] EXPRESSION_ATTRIBUTES = new String[]{"pointcut", "value"};
        private static final Map<Class<?>, AspectJAnnotationType> annotationTypeMap = Map.of(Pointcut.class, AspectJAnnotationType.AtPointcut, Around.class, AspectJAnnotationType.AtAround, Before.class, AspectJAnnotationType.AtBefore, After.class, AspectJAnnotationType.AtAfter, AfterReturning.class, AspectJAnnotationType.AtAfterReturning, AfterThrowing.class, AspectJAnnotationType.AtAfterThrowing);
        private final Annotation annotation;
        private final AspectJAnnotationType annotationType;
        private final String pointcutExpression;
        private final String argumentNames;

        public AspectJAnnotation(Annotation annotation) {
            this.annotation = annotation;
            this.annotationType = this.determineAnnotationType(annotation);
            try {
                String names;
                this.pointcutExpression = this.resolvePointcutExpression(annotation);
                Object argNames = AnnotationUtils.getValue(annotation, "argNames");
                this.argumentNames = argNames instanceof String ? (names = (String)argNames) : "";
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(annotation + " is not a valid AspectJ annotation", ex);
            }
        }

        private AspectJAnnotationType determineAnnotationType(Annotation annotation) {
            AspectJAnnotationType type = annotationTypeMap.get(annotation.annotationType());
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("Unknown annotation type: " + annotation);
        }

        private String resolvePointcutExpression(Annotation annotation) {
            for (String attributeName : EXPRESSION_ATTRIBUTES) {
                String str;
                Object val = AnnotationUtils.getValue(annotation, attributeName);
                if (!(val instanceof String) || (str = (String)val).isEmpty()) continue;
                return str;
            }
            throw new IllegalStateException("Failed to resolve pointcut expression in: " + annotation);
        }

        public AspectJAnnotationType getAnnotationType() {
            return this.annotationType;
        }

        public Annotation getAnnotation() {
            return this.annotation;
        }

        public String getPointcutExpression() {
            return this.pointcutExpression;
        }

        public String getArgumentNames() {
            return this.argumentNames;
        }

        public String toString() {
            return this.annotation.toString();
        }
    }

    protected static enum AspectJAnnotationType {
        AtPointcut,
        AtAround,
        AtBefore,
        AtAfter,
        AtAfterReturning,
        AtAfterThrowing;

    }
}

