/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.Field;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.Jre16Compat;
import org.apache.tomcat.util.res.StringManager;

public class Jre19Compat
extends Jre16Compat {
    private static final Log log = LogFactory.getLog(Jre19Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre19Compat.class);
    private static final boolean supported;

    static boolean isSupported() {
        return supported;
    }

    @Override
    public Object getExecutor(Thread thread2) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Object result = super.getExecutor(thread2);
        if (result == null) {
            Object holder = null;
            Object task2 = null;
            try {
                Field holderField = thread2.getClass().getDeclaredField("holder");
                holderField.setAccessible(true);
                holder = holderField.get(thread2);
                Field taskField = holder.getClass().getDeclaredField("task");
                taskField.setAccessible(true);
                task2 = taskField.get(holder);
            }
            catch (NoSuchFieldException nfe) {
                return null;
            }
            if (task2 != null && task2.getClass().getCanonicalName() != null && (task2.getClass().getCanonicalName().equals("org.apache.tomcat.util.threads.ThreadPoolExecutor.Worker") || task2.getClass().getCanonicalName().equals("java.util.concurrent.ThreadPoolExecutor.Worker"))) {
                Field executorField = task2.getClass().getDeclaredField("this$0");
                executorField.setAccessible(true);
                result = executorField.get(task2);
            }
        }
        return result;
    }

    static {
        Class<?> c1 = null;
        try {
            c1 = Class.forName("java.lang.WrongThreadException");
        }
        catch (ClassNotFoundException cnfe) {
            log.debug(sm.getString("jre19Compat.javaPre19"), cnfe);
        }
        supported = c1 != null;
    }
}

