/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ElementValue;

public class ArrayElementValue
extends ElementValue {
    private final ElementValue[] elementValues;

    ArrayElementValue(int type, ElementValue[] elementValues, ConstantPool cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new ClassFormatException("Only element values of type array can be built with this ctor - type specified: " + type);
        }
        this.elementValues = elementValues != null ? elementValues : EMPTY_ARRAY;
    }

    public ElementValue[] getElementValuesArray() {
        return this.elementValues;
    }

    @Override
    public String stringifyValue() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i2 = 0; i2 < this.elementValues.length; ++i2) {
            sb.append(this.elementValues[i2].stringifyValue());
            if (i2 + 1 >= this.elementValues.length) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }
}

