/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.LambdaUtil;
import org.apache.logging.log4j.util.StackLocatorUtil;
import org.apache.logging.log4j.util.Supplier;
import org.apache.logging.slf4j.SLF4JLogger;

public class SLF4JLogBuilder
implements LogBuilder {
    private static Message EMPTY_MESSAGE = new SimpleMessage("");
    private static final String FQCN = SLF4JLogBuilder.class.getName();
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ExtendedLogger logger;
    private Level level;
    private Marker marker;
    private Throwable throwable;
    private volatile boolean inUse;
    private final long threadId;

    public SLF4JLogBuilder(SLF4JLogger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.threadId = Thread.currentThread().getId();
        this.inUse = level != null;
    }

    public SLF4JLogBuilder() {
        this(null, null);
    }

    public LogBuilder reset(SLF4JLogger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.marker = null;
        this.throwable = null;
        this.inUse = true;
        return this;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    private boolean isValid() {
        if (!this.inUse) {
            LOGGER.warn("Attempt to reuse LogBuilder was ignored. {}", (Object)StackLocatorUtil.getCallerClass(2));
            return false;
        }
        if (this.threadId != Thread.currentThread().getId()) {
            LOGGER.warn("LogBuilder can only be used on the owning thread. {}", (Object)StackLocatorUtil.getCallerClass(2));
            return false;
        }
        return true;
    }

    private void logMessage(Message message2) {
        try {
            this.logger.logMessage(FQCN, this.level, this.marker, message2, this.throwable);
        }
        finally {
            this.inUse = false;
        }
    }

    @Override
    public LogBuilder withMarker(Marker marker) {
        this.marker = marker;
        return this;
    }

    @Override
    public LogBuilder withThrowable(Throwable throwable) {
        this.throwable = throwable;
        return this;
    }

    @Override
    public LogBuilder withLocation() {
        LOGGER.info("Call to withLocation() ignored since SLF4J does not support setting location information.");
        return this;
    }

    @Override
    public LogBuilder withLocation(StackTraceElement location) {
        return this.withLocation();
    }

    @Override
    public void log(CharSequence message2) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2));
        }
    }

    @Override
    public void log(String message2) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2));
        }
    }

    @Override
    public void log(String message2, Object ... params) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, params));
        }
    }

    @Override
    public void log(String message2, Supplier<?> ... params) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, LambdaUtil.getAll(params)));
        }
    }

    @Override
    public void log(Message message2) {
        if (this.isValid()) {
            this.logMessage(message2);
        }
    }

    @Override
    public void log(Supplier<Message> messageSupplier) {
        if (this.isValid()) {
            this.logMessage(messageSupplier.get());
        }
    }

    @Override
    public Message logAndGet(Supplier<Message> messageSupplier) {
        Message message2 = null;
        if (this.isValid()) {
            message2 = messageSupplier.get();
            this.logMessage(message2);
        }
        return message2;
    }

    @Override
    public void log(Object message2) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2));
        }
    }

    @Override
    public void log(String message2, Object p0) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1, Object p2) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1, p2));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1, Object p2, Object p3) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1, p2, p3));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1, Object p2, Object p3, Object p4) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1, p2, p3, p4));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1, p2, p3, p4, p5));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1, p2, p3, p4, p5, p6));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1, p2, p3, p4, p5, p6, p7));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1, p2, p3, p4, p5, p6, p7, p8));
        }
    }

    @Override
    public void log(String message2, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        if (this.isValid()) {
            this.logMessage(this.logger.getMessageFactory().newMessage(message2, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9));
        }
    }

    @Override
    public void log() {
        if (this.isValid()) {
            this.logMessage(EMPTY_MESSAGE);
        }
    }
}

