/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.spi.CleanableThreadContextMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.slf4j.MDC;

public class MDCContextMap
implements CleanableThreadContextMap {
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);

    @Override
    public void put(String key, String value) {
        MDC.put(key, value);
    }

    @Override
    public void putAll(Map<String, String> m) {
        for (Map.Entry<String, String> entry : m.entrySet()) {
            MDC.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String get(String key) {
        return MDC.get(key);
    }

    @Override
    public void remove(String key) {
        MDC.remove(key);
    }

    @Override
    public void removeAll(Iterable<String> keys2) {
        for (String key : keys2) {
            MDC.remove(key);
        }
    }

    @Override
    public void clear() {
        MDC.clear();
    }

    @Override
    public boolean containsKey(String key) {
        Map<String, String> map = MDC.getCopyOfContextMap();
        return map != null && map.containsKey(key);
    }

    @Override
    public Map<String, String> getCopy() {
        HashMap contextMap = MDC.getCopyOfContextMap();
        return contextMap != null ? contextMap : new HashMap();
    }

    @Override
    public Map<String, String> getImmutableMapOrNull() {
        return MDC.getCopyOfContextMap();
    }

    @Override
    public boolean isEmpty() {
        Map<String, String> map = MDC.getCopyOfContextMap();
        return map == null || map.isEmpty();
    }

    @Override
    public StringMap getReadOnlyContextData() {
        Map<String, String> copy = this.getCopy();
        if (copy.isEmpty()) {
            return EMPTY_CONTEXT_DATA;
        }
        SortedArrayStringMap result = new SortedArrayStringMap();
        for (Map.Entry<String, String> entry : copy.entrySet()) {
            result.putValue(entry.getKey(), entry.getValue());
        }
        return result;
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
    }
}

