/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import jakarta.servlet.FilterConfig;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.catalina.util.RateLimiter;
import org.apache.catalina.util.TimeBucketCounter;
import org.apache.tomcat.util.threads.ScheduledThreadPoolExecutor;

public class FastRateLimiter
implements RateLimiter {
    TimeBucketCounter bucketCounter;
    int duration;
    int requests;
    int actualRequests;
    int actualDuration;

    @Override
    public int getDuration() {
        return this.actualDuration;
    }

    @Override
    public void setDuration(int duration) {
        this.duration = duration;
    }

    @Override
    public int getRequests() {
        return this.actualRequests;
    }

    @Override
    public void setRequests(int requests) {
        this.requests = requests;
    }

    @Override
    public int increment(String ipAddress) {
        return this.bucketCounter.increment(ipAddress);
    }

    @Override
    public void destroy() {
        this.bucketCounter.destroy();
    }

    @Override
    public void setFilterConfig(FilterConfig filterConfig) {
        ScheduledExecutorService executorService = (ScheduledExecutorService)filterConfig.getServletContext().getAttribute(ScheduledThreadPoolExecutor.class.getName());
        if (executorService == null) {
            executorService = new java.util.concurrent.ScheduledThreadPoolExecutor(1);
        }
        this.bucketCounter = new TimeBucketCounter(this.duration, executorService);
        this.actualRequests = (int)Math.round(this.bucketCounter.getRatio() * (double)this.requests);
        this.actualDuration = this.bucketCounter.getActualDuration() / 1000;
    }

    public TimeBucketCounter getBucketCounter() {
        return this.bucketCounter;
    }
}

