/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.catalina.filters.FilterBase;
import org.apache.catalina.util.NetMask;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.StringUtils;

public final class RemoteCIDRFilter
extends FilterBase {
    private static final String PLAIN_TEXT_MIME_TYPE = "text/plain";
    private final Log log = LogFactory.getLog(RemoteCIDRFilter.class);
    private final List<NetMask> allow = new ArrayList<NetMask>();
    private final List<NetMask> deny = new ArrayList<NetMask>();

    public String getAllow() {
        return this.allow.toString().replace("[", "").replace("]", "");
    }

    public void setAllow(String input) {
        List<String> messages = this.fillFromInput(input, this.allow);
        if (messages.isEmpty()) {
            return;
        }
        for (String message2 : messages) {
            this.log.error(message2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrFilter.invalid", "allow"));
    }

    public String getDeny() {
        return this.deny.toString().replace("[", "").replace("]", "");
    }

    public void setDeny(String input) {
        List<String> messages = this.fillFromInput(input, this.deny);
        if (messages.isEmpty()) {
            return;
        }
        for (String message2 : messages) {
            this.log.error(message2);
        }
        throw new IllegalArgumentException(sm.getString("remoteCidrFilter.invalid", "deny"));
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isAllowed(request.getRemoteAddr())) {
            chain.doFilter(request, response);
            return;
        }
        if (!(response instanceof HttpServletResponse)) {
            this.sendErrorWhenNotHttp(response);
            return;
        }
        ((HttpServletResponse)response).sendError(403);
    }

    @Override
    public Log getLogger() {
        return this.log;
    }

    private boolean isAllowed(String property) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(property);
        }
        catch (UnknownHostException e) {
            this.log.error(sm.getString("remoteCidrFilter.noRemoteIp"), e);
            return false;
        }
        for (NetMask nm : this.deny) {
            if (!nm.matches(addr)) continue;
            return false;
        }
        for (NetMask nm : this.allow) {
            if (!nm.matches(addr)) continue;
            return true;
        }
        return !this.deny.isEmpty() && this.allow.isEmpty();
    }

    private void sendErrorWhenNotHttp(ServletResponse response) throws IOException {
        PrintWriter writer = response.getWriter();
        response.setContentType(PLAIN_TEXT_MIME_TYPE);
        writer.write(sm.getString("http.403"));
        writer.flush();
    }

    private List<String> fillFromInput(String input, List<NetMask> target) {
        target.clear();
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CallSite> messages = new ArrayList<CallSite>();
        for (String s : StringUtils.splitCommaSeparated(input)) {
            try {
                NetMask nm = new NetMask(s);
                target.add(nm);
            }
            catch (IllegalArgumentException e) {
                messages.add((CallSite)((Object)(s + ": " + e.getMessage())));
            }
        }
        return Collections.unmodifiableList(messages);
    }
}

