/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.catalina.Executor;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.threads.VirtualThreadExecutor;

public class StandardVirtualThreadExecutor
extends LifecycleMBeanBase
implements Executor,
ExecutorService {
    private static final StringManager sm = StringManager.getManager(StandardVirtualThreadExecutor.class);
    private String name;
    private ExecutorService executor;
    private String namePrefix = "tomcat-virt-";

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    @Override
    public void execute(Runnable command) {
        if (this.executor == null) {
            throw new IllegalStateException(sm.getString("standardVirtualThreadExecutor.notStarted"));
        }
        this.executor.execute(command);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (!JreCompat.isJre21Available()) {
            throw new LifecycleException(sm.getString("standardVirtualThreadExecutor.noVirtualThreads"));
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.executor = new VirtualThreadExecutor(this.getNamePrefix());
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.executor = null;
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected String getDomainInternal() {
        return null;
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return "type=Executor,name=" + this.getName();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        if (this.executor != null) {
            return this.executor.isShutdown();
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public boolean isTerminated() {
        if (this.executor != null) {
            return this.executor.isTerminated();
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task2) {
        if (this.executor != null) {
            return this.executor.submit(task2);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> Future<T> submit(Runnable task2, T result) {
        if (this.executor != null) {
            return this.executor.submit(task2, result);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public Future<?> submit(Runnable task2) {
        if (this.executor != null) {
            return this.executor.submit(task2);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (this.executor != null) {
            return this.executor.invokeAll(tasks);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.executor != null) {
            return this.executor.invokeAll(tasks, timeout, unit);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (this.executor != null) {
            return this.executor.invokeAny(tasks);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.executor != null) {
            return this.executor.invokeAny(tasks, timeout, unit);
        }
        throw new IllegalStateException(sm.getString("standardThreadExecutor.notStarted"));
    }
}

