/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.skin.LabeledSkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class ButtonSkin
extends LabeledSkinBase<Button> {
    private KeyCodeCombination defaultAcceleratorKeyCodeCombination;
    private KeyCodeCombination cancelAcceleratorKeyCodeCombination;
    private final BehaviorBase<Button> behavior;
    Runnable defaultButtonRunnable = () -> {
        if (((Button)this.getSkinnable()).getScene() != null && NodeHelper.isTreeVisible((Node)((Object)this.getSkinnable())) && !((Button)this.getSkinnable()).isDisabled()) {
            ((Button)this.getSkinnable()).fire();
        }
    };
    Runnable cancelButtonRunnable = () -> {
        if (((Button)this.getSkinnable()).getScene() != null && NodeHelper.isTreeVisible((Node)((Object)this.getSkinnable())) && !((Button)this.getSkinnable()).isDisabled()) {
            ((Button)this.getSkinnable()).fire();
        }
    };
    ChangeListener<Scene> sceneChangeListener = (observableValue, scene2, scene3) -> {
        if (scene2 != null) {
            if (((Button)this.getSkinnable()).isDefaultButton()) {
                this.setDefaultButton((Scene)scene2, false);
            }
            if (((Button)this.getSkinnable()).isCancelButton()) {
                this.setCancelButton((Scene)scene2, false);
            }
        }
        if (scene3 != null) {
            if (((Button)this.getSkinnable()).isDefaultButton()) {
                this.setDefaultButton((Scene)scene3, true);
            }
            if (((Button)this.getSkinnable()).isCancelButton()) {
                this.setCancelButton((Scene)scene3, true);
            }
        }
    };
    WeakChangeListener<Scene> weakSceneChangeListener = new WeakChangeListener<Scene>(this.sceneChangeListener);

    public ButtonSkin(Button button) {
        super(button);
        this.behavior = new ButtonBehavior<Button>(button);
        this.registerChangeListener(button.defaultButtonProperty(), observableValue -> this.setDefaultButton(((Button)this.getSkinnable()).isDefaultButton()));
        this.registerChangeListener(button.cancelButtonProperty(), observableValue -> this.setCancelButton(((Button)this.getSkinnable()).isCancelButton()));
        this.registerChangeListener(button.focusedProperty(), observableValue -> {
            ContextMenu contextMenu;
            if (!((Button)this.getSkinnable()).isFocused() && (contextMenu = ((Button)this.getSkinnable()).getContextMenu()) != null && contextMenu.isShowing()) {
                contextMenu.hide();
                Utils.removeMnemonics(contextMenu, ((Button)this.getSkinnable()).getScene());
            }
        });
        this.registerChangeListener(button.parentProperty(), observableValue -> {
            if (((Button)this.getSkinnable()).getParent() == null && ((Button)this.getSkinnable()).getScene() != null) {
                if (((Button)this.getSkinnable()).isDefaultButton()) {
                    ((Button)this.getSkinnable()).getScene().getAccelerators().remove(this.defaultAcceleratorKeyCodeCombination);
                }
                if (((Button)this.getSkinnable()).isCancelButton()) {
                    ((Button)this.getSkinnable()).getScene().getAccelerators().remove(this.cancelAcceleratorKeyCodeCombination);
                }
            }
        });
        button.sceneProperty().addListener(this.weakSceneChangeListener);
        if (((Button)this.getSkinnable()).isDefaultButton()) {
            this.setDefaultButton(true);
        }
        if (((Button)this.getSkinnable()).isCancelButton()) {
            this.setCancelButton(true);
        }
    }

    @Override
    public void dispose() {
        if (this.getSkinnable() == null) {
            return;
        }
        if (((Button)this.getSkinnable()).isDefaultButton()) {
            this.setDefaultButton(false);
        }
        if (((Button)this.getSkinnable()).isCancelButton()) {
            this.setCancelButton(false);
        }
        ((Button)this.getSkinnable()).sceneProperty().removeListener(this.weakSceneChangeListener);
        super.dispose();
        if (this.behavior != null) {
            this.behavior.dispose();
        }
    }

    private void setDefaultButton(boolean bl) {
        this.setDefaultButton(((Button)this.getSkinnable()).getScene(), bl);
    }

    private void setDefaultButton(Scene scene2, boolean bl) {
        if (scene2 != null) {
            KeyCode keyCode = KeyCode.ENTER;
            this.defaultAcceleratorKeyCodeCombination = new KeyCodeCombination(keyCode, new KeyCombination.Modifier[0]);
            Runnable runnable = (Runnable)scene2.getAccelerators().get(this.defaultAcceleratorKeyCodeCombination);
            if (!bl) {
                if (this.defaultButtonRunnable.equals(runnable)) {
                    scene2.getAccelerators().remove(this.defaultAcceleratorKeyCodeCombination);
                }
            } else if (!this.defaultButtonRunnable.equals(runnable)) {
                scene2.getAccelerators().remove(this.defaultAcceleratorKeyCodeCombination);
                scene2.getAccelerators().put(this.defaultAcceleratorKeyCodeCombination, this.defaultButtonRunnable);
            }
        }
    }

    private void setCancelButton(boolean bl) {
        this.setCancelButton(((Button)this.getSkinnable()).getScene(), bl);
    }

    private void setCancelButton(Scene scene2, boolean bl) {
        if (scene2 != null) {
            KeyCode keyCode = KeyCode.ESCAPE;
            this.cancelAcceleratorKeyCodeCombination = new KeyCodeCombination(keyCode, new KeyCombination.Modifier[0]);
            Runnable runnable = (Runnable)scene2.getAccelerators().get(this.cancelAcceleratorKeyCodeCombination);
            if (!bl) {
                if (this.cancelButtonRunnable.equals(runnable)) {
                    scene2.getAccelerators().remove(this.cancelAcceleratorKeyCodeCombination);
                }
            } else if (!this.cancelButtonRunnable.equals(runnable)) {
                scene2.getAccelerators().remove(this.cancelAcceleratorKeyCodeCombination);
                scene2.getAccelerators().put(this.cancelAcceleratorKeyCodeCombination, this.cancelButtonRunnable);
            }
        }
    }
}

