/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELManager;
import jakarta.el.ELResolver;
import jakarta.el.EvaluationListener;
import jakarta.el.FunctionMapper;
import jakarta.el.ImportHandler;
import jakarta.el.LambdaExpression;
import jakarta.el.Util;
import jakarta.el.VariableMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public abstract class ELContext {
    private Locale locale;
    private Map<Class<?>, Object> map;
    private boolean resolved = false;
    private ImportHandler importHandler = null;
    private List<EvaluationListener> listeners;
    private Deque<Map<String, Object>> lambdaArguments = null;

    private Deque<Map<String, Object>> getLambdaArguments() {
        if (this.lambdaArguments == null) {
            this.lambdaArguments = new ArrayDeque<Map<String, Object>>(4);
        }
        return this.lambdaArguments;
    }

    public void setPropertyResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public void setPropertyResolved(Object base, Object property) {
        this.setPropertyResolved(true);
        this.notifyPropertyResolved(base, property);
    }

    public boolean isPropertyResolved() {
        return this.resolved;
    }

    public void putContext(Class<?> key, Object contextObject) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(contextObject);
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(key, contextObject);
    }

    public Object getContext(Class<?> key) {
        Objects.requireNonNull(key);
        if (this.map == null) {
            return null;
        }
        return this.map.get(key);
    }

    public abstract ELResolver getELResolver();

    public ImportHandler getImportHandler() {
        if (this.importHandler == null) {
            this.importHandler = new ImportHandler();
        }
        return this.importHandler;
    }

    public abstract FunctionMapper getFunctionMapper();

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public abstract VariableMapper getVariableMapper();

    public void addEvaluationListener(EvaluationListener listener2) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<EvaluationListener>();
        }
        this.listeners.add(listener2);
    }

    public List<EvaluationListener> getEvaluationListeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners;
    }

    public void notifyBeforeEvaluation(String expression) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener listener2 : this.listeners) {
            try {
                listener2.beforeEvaluation(this, expression);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
            }
        }
    }

    public void notifyAfterEvaluation(String expression) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener listener2 : this.listeners) {
            try {
                listener2.afterEvaluation(this, expression);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
            }
        }
    }

    public void notifyPropertyResolved(Object base, Object property) {
        if (this.listeners == null) {
            return;
        }
        for (EvaluationListener listener2 : this.listeners) {
            try {
                listener2.propertyResolved(this, base, property);
            }
            catch (Throwable t) {
                Util.handleThrowable(t);
            }
        }
    }

    public boolean isLambdaArgument(String name) {
        for (Map<String, Object> arguments : this.getLambdaArguments()) {
            if (!arguments.containsKey(name)) continue;
            return true;
        }
        return false;
    }

    public Object getLambdaArgument(String name) {
        for (Map<String, Object> arguments : this.getLambdaArguments()) {
            Object result = arguments.get(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void enterLambdaScope(Map<String, Object> arguments) {
        this.getLambdaArguments().push(arguments);
    }

    public void exitLambdaScope() {
        this.getLambdaArguments().pop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertToType(Object obj, Class<T> type) {
        boolean originalResolved = this.isPropertyResolved();
        this.setPropertyResolved(false);
        try {
            ELResolver resolver = this.getELResolver();
            if (resolver != null) {
                T result = resolver.convertToType(this, obj, type);
                if (this.isPropertyResolved()) {
                    T t = result;
                    return t;
                }
            }
        }
        finally {
            this.setPropertyResolved(originalResolved);
        }
        if (obj instanceof LambdaExpression && ELContext.isFunctionalInterface(type)) {
            ((LambdaExpression)obj).setELContext(this);
        }
        return ELManager.getExpressionFactory().coerceToType(obj, type);
    }

    static boolean isFunctionalInterface(Class<?> type) {
        Method[] methods;
        if (!type.isInterface()) {
            return false;
        }
        boolean foundAbstractMethod = false;
        for (Method method : methods = type.getMethods()) {
            if (!Modifier.isAbstract(method.getModifiers()) || ELContext.overridesObjectMethod(method)) continue;
            if (foundAbstractMethod) {
                return false;
            }
            foundAbstractMethod = true;
        }
        return foundAbstractMethod;
    }

    private static boolean overridesObjectMethod(Method method) {
        return "equals".equals(method.getName()) ? method.getReturnType().equals(Boolean.TYPE) && method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(Object.class) : ("hashCode".equals(method.getName()) ? method.getReturnType().equals(Integer.TYPE) && method.getParameterCount() == 0 : "toString".equals(method.getName()) && method.getReturnType().equals(String.class) && method.getParameterCount() == 0);
    }
}

