/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.stage;

import com.sun.javafx.stage.WindowPeerListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.util.Utils;
import java.security.AccessControlContext;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.stage.Screen;
import javafx.stage.Window;

public class WindowHelper {
    private static final WindowHelper theInstance = new WindowHelper();
    private static WindowAccessor windowAccessor;

    protected WindowHelper() {
    }

    private static WindowHelper getInstance() {
        return theInstance;
    }

    public static void initHelper(Window window2) {
        WindowHelper.setHelper(window2, WindowHelper.getInstance());
    }

    private static WindowHelper getHelper(Window window2) {
        return windowAccessor.getHelper(window2);
    }

    protected static void setHelper(Window window2, WindowHelper windowHelper) {
        windowAccessor.setHelper(window2, windowHelper);
    }

    public static void visibleChanging(Window window2, boolean bl) {
        WindowHelper.getHelper(window2).visibleChangingImpl(window2, bl);
    }

    public static void visibleChanged(Window window2, boolean bl) {
        WindowHelper.getHelper(window2).visibleChangedImpl(window2, bl);
    }

    protected void visibleChangingImpl(Window window2, boolean bl) {
        windowAccessor.doVisibleChanging(window2, bl);
    }

    protected void visibleChangedImpl(Window window2, boolean bl) {
        windowAccessor.doVisibleChanged(window2, bl);
    }

    public static TKStage getPeer(Window window2) {
        return windowAccessor.getPeer(window2);
    }

    public static void setPeer(Window window2, TKStage tKStage) {
        windowAccessor.setPeer(window2, tKStage);
    }

    public static WindowPeerListener getPeerListener(Window window2) {
        return windowAccessor.getPeerListener(window2);
    }

    public static void setPeerListener(Window window2, WindowPeerListener windowPeerListener) {
        windowAccessor.setPeerListener(window2, windowPeerListener);
    }

    public static void setFocused(Window window2, boolean bl) {
        windowAccessor.setFocused(window2, bl);
    }

    public static void notifyLocationChanged(Window window2, double d, double d2) {
        windowAccessor.notifyLocationChanged(window2, d, d2);
    }

    public static void notifySizeChanged(Window window2, double d, double d2) {
        windowAccessor.notifySizeChanged(window2, d, d2);
    }

    public static void notifyScaleChanged(Window window2, double d, double d2) {
        windowAccessor.notifyScaleChanged(window2, d, d2);
    }

    static AccessControlContext getAccessControlContext(Window window2) {
        return windowAccessor.getAccessControlContext(window2);
    }

    public static void setWindowAccessor(WindowAccessor windowAccessor) {
        if (WindowHelper.windowAccessor != null) {
            throw new IllegalStateException();
        }
        WindowHelper.windowAccessor = windowAccessor;
    }

    public static WindowAccessor getWindowAccessor() {
        return windowAccessor;
    }

    static {
        Utils.forceInit(Window.class);
    }

    public static interface WindowAccessor {
        public WindowHelper getHelper(Window var1);

        public void setHelper(Window var1, WindowHelper var2);

        public void doVisibleChanging(Window var1, boolean var2);

        public void doVisibleChanged(Window var1, boolean var2);

        public TKStage getPeer(Window var1);

        public void setPeer(Window var1, TKStage var2);

        public WindowPeerListener getPeerListener(Window var1);

        public void setPeerListener(Window var1, WindowPeerListener var2);

        public void setFocused(Window var1, boolean var2);

        public void notifyLocationChanged(Window var1, double var2, double var4);

        public void notifySizeChanged(Window var1, double var2, double var4);

        public void notifyScreenChanged(Window var1, Object var2, Object var3);

        public float getPlatformScaleX(Window var1);

        public float getPlatformScaleY(Window var1);

        public void notifyScaleChanged(Window var1, double var2, double var4);

        public ReadOnlyObjectProperty<Screen> screenProperty(Window var1);

        public AccessControlContext getAccessControlContext(Window var1);
    }
}

