/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import com.sun.javafx.scene.control.ConstrainedColumnResize;
import java.util.BitSet;
import java.util.List;
import javafx.scene.control.ResizeFeaturesBase;
import javafx.scene.control.TableColumnBase;
import javafx.scene.layout.Region;

public class ResizeHelper {
    private static final int SMALL_DELTA = 32;
    private static final double EPSILON = 1.0E-6;
    private final ResizeFeaturesBase rf;
    private final double target;
    private final List<? extends TableColumnBase<?, ?>> columns;
    private final int count;
    private final ConstrainedColumnResize.ResizeMode mode;
    private final double[] size;
    private final double[] min;
    private final double[] pref;
    private final double[] max;
    private final BitSet skip;
    private final Region snap;

    public ResizeHelper(ResizeFeaturesBase resizeFeaturesBase, double d, List<? extends TableColumnBase<?, ?>> list, ConstrainedColumnResize.ResizeMode resizeMode) {
        this.rf = resizeFeaturesBase;
        this.snap = resizeFeaturesBase.getTableControl().isSnapToPixel() ? resizeFeaturesBase.getTableControl() : null;
        this.columns = list;
        this.mode = resizeMode;
        this.target = this.snap(d);
        this.count = list.size();
        this.size = new double[this.count];
        this.min = new double[this.count];
        this.pref = new double[this.count];
        this.max = new double[this.count];
        this.skip = new BitSet(this.count);
        for (int j = 0; j < this.count; ++j) {
            TableColumnBase<?, ?> tableColumnBase = list.get(j);
            this.size[j] = tableColumnBase.getWidth();
            if (tableColumnBase.isResizable()) {
                double d2 = tableColumnBase.getMinWidth();
                double d3 = tableColumnBase.getMaxWidth();
                this.min[j] = d2;
                this.max[j] = d3;
                this.pref[j] = ResizeHelper.clip(tableColumnBase.getPrefWidth(), d2, d3);
                continue;
            }
            this.skip.set(j, true);
        }
    }

    public void resizeToContentWidth() {
        boolean bl;
        block0: do {
            int n;
            bl = false;
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < this.count; ++j) {
                d += this.size[j];
                d2 += this.min[j];
            }
            if (d2 >= this.target) {
                return;
            }
            double d3 = this.target - this.snap(d);
            if (ResizeHelper.isZero(d3)) {
                return;
            }
            double d4 = 0.0;
            for (n = 0; n < this.count; ++n) {
                if (this.skip.get(n)) continue;
                d4 += this.pref[n];
            }
            if (ResizeHelper.isZero(d4)) {
                return;
            }
            if (Math.abs(d3) < 32.0) {
                this.distributeSmallDelta(d3);
                return;
            }
            for (n = 0; n < this.count; ++n) {
                if (this.skip.get(n)) continue;
                double d5 = this.size[n] + d3 * this.pref[n] / d4;
                if (d5 < this.min[n]) {
                    d5 = this.min[n];
                    this.skip.set(n, true);
                    bl = true;
                } else if (d5 > this.max[n]) {
                    d5 = this.max[n];
                    this.skip.set(n, true);
                    bl = true;
                }
                this.size[n] = d5;
                if (!bl) continue;
                this.resetSizeChanges();
                continue block0;
            }
        } while (bl);
    }

    public boolean applySizes() {
        double d = 0.0;
        double d2 = 0.0;
        for (int j = 0; j < this.count; ++j) {
            TableColumnBase<?, ?> tableColumnBase = this.columns.get(j);
            if (tableColumnBase.isResizable()) {
                d = this.snap(d + this.size[j]);
                double d3 = d - d2;
                this.rf.setColumnWidth(tableColumnBase, d3);
            } else {
                d += this.size[j];
            }
            d2 = d;
        }
        return d > this.target;
    }

    protected static double clip(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public boolean resizeColumn(TableColumnBase<?, ?> tableColumnBase) {
        boolean bl;
        double d = this.rf.getDelta();
        TableColumnBase tableColumnBase2 = tableColumnBase;
        while (tableColumnBase2.getColumns().size() > 0) {
            tableColumnBase2 = (TableColumnBase)tableColumnBase2.getColumns().get(tableColumnBase2.getColumns().size() - 1);
        }
        if (!tableColumnBase2.isResizable()) {
            return false;
        }
        int n = this.columns.indexOf(tableColumnBase2);
        double d2 = this.getAllowedDelta(n, bl = d > 0.0);
        if (ResizeHelper.isZero(d2)) {
            return false;
        }
        int n2 = this.markOppositeColumns(n);
        if (n2 == 0) {
            return false;
        }
        double d3 = this.computeAllowedDelta(!bl);
        if (ResizeHelper.isZero(d3)) {
            return false;
        }
        d2 = Math.min(Math.abs(d), Math.min(d2, d3));
        if (!bl) {
            d2 = -d2;
        }
        if (this.isCornerCase(d2, n)) {
            return false;
        }
        return this.distributeDelta(n, d2);
    }

    protected boolean isCornerCase(double d, int n) {
        int n2;
        boolean bl;
        boolean bl2 = bl = n == this.count - 2;
        return bl && d > 0.0 && this.size[n2 = this.count - 1] <= this.min[n2];
    }

    protected double getAllowedDelta(int n, boolean bl) {
        if (bl) {
            return Math.abs(this.max[n] - this.size[n]);
        }
        return Math.abs(this.min[n] - this.size[n]);
    }

    protected int markOppositeColumns(int n) {
        switch (this.mode) {
            case AUTO_RESIZE_NEXT_COLUMN: {
                this.setSkip(0, n + 1);
                this.setSkip(n + 2, this.columns.size());
                break;
            }
            case AUTO_RESIZE_FLEX_HEAD: 
            case AUTO_RESIZE_FLEX_TAIL: 
            case AUTO_RESIZE_SUBSEQUENT_COLUMNS: {
                this.setSkip(0, n + 1);
                break;
            }
            case AUTO_RESIZE_LAST_COLUMN: {
                this.setSkip(0, Math.max(n + 1, this.columns.size() - 1));
                break;
            }
            default: {
                this.setSkip(n, n + 1);
            }
        }
        return this.count - this.skip.cardinality();
    }

    protected void setSkip(int n, int n2) {
        if (n < 0) {
            n = 0;
        } else if (n >= this.count) {
            return;
        }
        int n3 = Math.min(this.count, n2);
        if (n < n3) {
            this.skip.set(n, n3);
        }
    }

    protected double computeAllowedDelta(boolean bl) {
        double d = 0.0;
        int n = 0;
        while ((n = this.skip.nextClearBit(n)) < this.count) {
            d = bl ? (d += this.max[n] - this.size[n]) : (d += this.size[n] - this.min[n]);
            ++n;
        }
        return d;
    }

    protected boolean distributeDelta(int n, double d) {
        int n2 = this.count - this.skip.cardinality();
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                int n3 = this.skip.nextClearBit(0);
                int n4 = n;
                this.size[n4] = this.size[n4] + d;
                int n5 = n3;
                this.size[n5] = this.size[n5] - d;
                return true;
            }
        }
        int n6 = n;
        this.size[n6] = this.size[n6] + d;
        double d2 = switch (this.mode) {
            case ConstrainedColumnResize.ResizeMode.AUTO_RESIZE_FLEX_HEAD -> this.distributeDeltaFlexHead(-d);
            case ConstrainedColumnResize.ResizeMode.AUTO_RESIZE_FLEX_TAIL -> this.distributeDeltaFlexTail(-d);
            default -> {
                if (Math.abs(d) < 32.0) {
                    this.distributeSmallDelta(-d);
                } else {
                    this.distributeDeltaRemainingColumns(-d);
                }
                yield 0.0;
            }
        };
        int n7 = n;
        this.size[n7] = this.size[n7] + d2;
        return true;
    }

    protected double distributeDeltaFlexHead(double d) {
        int n;
        if (d < 0.0) {
            for (n = 0; !(n >= this.count || !this.skip.get(n) && this.size[n] > this.pref[n] && ResizeHelper.isZero(d = this.resize(n, d))); ++n) {
            }
        } else {
            for (n = 0; !(n >= this.count || !this.skip.get(n) && this.size[n] < this.pref[n] && ResizeHelper.isZero(d = this.resize(n, d))); ++n) {
            }
        }
        for (n = 0; n < this.count && (this.skip.get(n) || !ResizeHelper.isZero(d = this.resize(n, d))); ++n) {
        }
        return d;
    }

    protected double distributeDeltaFlexTail(double d) {
        int n;
        if (d < 0.0) {
            for (n = this.count - 1; !(n < 0 || !this.skip.get(n) && this.size[n] > this.pref[n] && ResizeHelper.isZero(d = this.resize(n, d))); --n) {
            }
        } else {
            for (n = this.count - 1; !(n < 0 || !this.skip.get(n) && this.size[n] < this.pref[n] && ResizeHelper.isZero(d = this.resize(n, d))); --n) {
            }
        }
        for (n = this.count - 1; n >= 0 && (this.skip.get(n) || !ResizeHelper.isZero(d = this.resize(n, d))); --n) {
        }
        return d;
    }

    protected double resize(int n, double d) {
        double d2 = this.size[n] + d;
        if (d2 < this.min[n]) {
            d = d2 - this.min[n];
            d2 = this.min[n];
        } else if (d2 > this.max[n]) {
            d = d2 - this.max[n];
            d2 = this.max[n];
        } else {
            d = 0.0;
        }
        this.size[n] = d2;
        return d;
    }

    protected void distributeDeltaRemainingColumns(double d) {
        boolean bl;
        block0: do {
            int n;
            double d2 = 0.0;
            for (n = 0; n < this.count; ++n) {
                if (this.skip.get(n)) continue;
                d2 += this.pref[n];
            }
            if (ResizeHelper.isZero(d2)) {
                return;
            }
            bl = false;
            for (n = 0; n < this.count; ++n) {
                if (this.skip.get(n)) continue;
                double d3 = this.size[n] + d * this.pref[n] / d2;
                if (d3 < this.min[n]) {
                    d3 = this.min[n];
                    this.skip.set(n, true);
                    bl = true;
                    d -= d3 - this.size[n];
                } else if (d3 > this.max[n]) {
                    d3 = this.max[n];
                    this.skip.set(n, true);
                    bl = true;
                    d -= d3 - this.size[n];
                }
                this.size[n] = d3;
                if (!bl) continue;
                this.resetSizeChanges();
                continue block0;
            }
        } while (bl);
    }

    protected void distributeSmallDelta(double d) {
        if (d < 0.0) {
            while (d < 0.0) {
                double d2 = Math.max(-1.0, d);
                double d3 = this.shrinkSmall(d2);
                if (Double.isNaN(d3)) {
                    return;
                }
                d -= d2 - d3;
            }
        } else {
            while (d > 0.0) {
                double d4 = Math.min(1.0, d);
                double d5 = this.expandSmall(d4);
                if (Double.isNaN(d5)) {
                    return;
                }
                d -= d4 - d5;
            }
        }
    }

    protected double shrinkSmall(double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        int n = -1;
        for (int j = 0; j < this.count; ++j) {
            double d3;
            if (this.skip.get(j) || !((d3 = this.size[j] - this.pref[j]) > d2)) continue;
            d2 = d3;
            n = j;
        }
        if (n < 0) {
            return Double.NaN;
        }
        double d4 = 0.0;
        double d5 = this.size[n] + d;
        if (d5 < this.min[n]) {
            d4 = d5 - this.min[n];
            d5 = this.min[n];
            this.skip.set(n);
        }
        this.size[n] = d5;
        return d4;
    }

    protected double expandSmall(double d) {
        double d2 = Double.NEGATIVE_INFINITY;
        int n = -1;
        for (int j = 0; j < this.count; ++j) {
            double d3;
            if (this.skip.get(j) || !((d3 = this.pref[j] - this.size[j]) > d2)) continue;
            d2 = d3;
            n = j;
        }
        if (n < 0) {
            return Double.NaN;
        }
        double d4 = 0.0;
        double d5 = this.size[n] + d;
        if (d5 > this.max[n]) {
            d4 = d5 - this.max[n];
            d5 = this.max[n];
            this.skip.set(n);
        }
        this.size[n] = d5;
        return d4;
    }

    protected void resetSizeChanges() {
        for (int j = 0; j < this.count; ++j) {
            if (this.skip.get(j)) continue;
            this.size[j] = this.columns.get(j).getWidth();
        }
    }

    protected double sumSizes() {
        double d = 0.0;
        for (int j = 0; j < this.count; ++j) {
            d += this.size[j];
        }
        return d;
    }

    protected static boolean isZero(double d) {
        return Math.abs(d) < 1.0E-6;
    }

    protected double snap(double d) {
        if (this.snap == null) {
            return d;
        }
        return this.snap.snapSpaceX(d);
    }
}

