/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.input.KeyCombination;

public class ControlAcceleratorSupport {
    private static Map<Object, WeakReference<ChangeListener<Scene>>> sceneChangeListenerMap = new WeakHashMap<Object, WeakReference<ChangeListener<Scene>>>();
    private static Map<ListChangeListener<MenuItem>, WeakReference<ListChangeListener<MenuItem>>> menuListChangeListenerMap = new WeakHashMap<ListChangeListener<MenuItem>, WeakReference<ListChangeListener<MenuItem>>>();
    private static Map<MenuItem, WeakReference<ChangeListener<KeyCombination>>> changeListenerMap = new WeakHashMap<MenuItem, WeakReference<ChangeListener<KeyCombination>>>();

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, Tab tab) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, (Object)tab);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, TableColumnBase<?, ?> tableColumnBase) {
        ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, tableColumnBase);
    }

    public static void addAcceleratorsIntoScene(ObservableList<MenuItem> observableList, Node node) {
        if (observableList == null) {
            return;
        }
        if (node == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        WeakReference<ChangeListener<Scene>> weakReference = sceneChangeListenerMap.get(node);
        if (weakReference == null || weakReference.get() == null) {
            Scene scene2 = node.getScene();
            if (scene2 != null) {
                ControlAcceleratorSupport.doAcceleratorInstall(observableList, scene2);
            }
            node.sceneProperty().addListener(ControlAcceleratorSupport.getSceneChangeListener(node, observableList));
        }
    }

    private static void addAcceleratorsIntoScene(final ObservableList<MenuItem> observableList, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("Anchor cannot be null");
        }
        final ReadOnlyObjectProperty<? extends Control> readOnlyObjectProperty = ControlAcceleratorSupport.getControlProperty(object);
        Control control = (Control)readOnlyObjectProperty.get();
        if (control == null) {
            readOnlyObjectProperty.addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable2) {
                    Control control = (Control)readOnlyObjectProperty.get();
                    if (control != null) {
                        readOnlyObjectProperty.removeListener(this);
                        ControlAcceleratorSupport.addAcceleratorsIntoScene((ObservableList<MenuItem>)observableList, control);
                    }
                }
            });
        } else {
            ControlAcceleratorSupport.addAcceleratorsIntoScene(observableList, control);
        }
    }

    private static ChangeListener<Scene> getSceneChangeListener(Object object, ObservableList<MenuItem> observableList) {
        ChangeListener<Scene> changeListener;
        WeakReference<ChangeListener<Scene>> weakReference = sceneChangeListenerMap.get(object);
        ChangeListener<Scene> changeListener2 = changeListener = weakReference == null ? null : (ChangeListener<Scene>)weakReference.get();
        if (changeListener == null) {
            changeListener = (observableValue, scene2, scene3) -> {
                if (scene2 != null) {
                    ControlAcceleratorSupport.removeAcceleratorsFromScene((ObservableList<? extends MenuItem>)observableList, scene2);
                }
                if (scene3 != null) {
                    ControlAcceleratorSupport.doAcceleratorInstall(observableList, scene3);
                }
            };
            sceneChangeListenerMap.put(object, new WeakReference<ChangeListener<Scene>>(changeListener));
        }
        return changeListener;
    }

    private static void doAcceleratorInstall(ObservableList<MenuItem> observableList, final Scene scene2) {
        ListChangeListener listChangeListener;
        IdentityWrapperListChangeListener identityWrapperListChangeListener = new IdentityWrapperListChangeListener(observableList){

            @Override
            public void onChanged(ListChangeListener.Change<? extends MenuItem> change) {
                while (change.next()) {
                    if (change.wasRemoved()) {
                        ControlAcceleratorSupport.removeAcceleratorsFromScene(change.getRemoved(), scene2);
                    }
                    if (!change.wasAdded()) continue;
                    ControlAcceleratorSupport.doAcceleratorInstall(change.getAddedSubList(), scene2);
                }
            }
        };
        WeakReference<ListChangeListener<MenuItem>> weakReference = menuListChangeListenerMap.get(identityWrapperListChangeListener);
        ListChangeListener listChangeListener2 = listChangeListener = weakReference == null ? null : (ListChangeListener)weakReference.get();
        if (listChangeListener != null) {
            observableList.removeListener(listChangeListener);
        }
        menuListChangeListenerMap.put(identityWrapperListChangeListener, new WeakReference<2>(identityWrapperListChangeListener));
        observableList.addListener(identityWrapperListChangeListener);
        ControlAcceleratorSupport.doAcceleratorInstall(observableList, scene2);
    }

    private static void doAcceleratorInstall(List<? extends MenuItem> list, Scene scene2) {
        for (MenuItem menuItem : list) {
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.doAcceleratorInstall(((Menu)menuItem).getItems(), scene2);
                continue;
            }
            if (menuItem.getAccelerator() != null) {
                ObservableMap<KeyCombination, Runnable> observableMap = scene2.getAccelerators();
                Runnable runnable = () -> {
                    Menu menu;
                    if (menuItem.getOnMenuValidation() != null) {
                        Event.fireEvent(menuItem, new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if ((menu = menuItem.getParentMenu()) != null && menu.getOnMenuValidation() != null) {
                        Event.fireEvent(menu, new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if (!menuItem.isDisable()) {
                        if (menuItem instanceof RadioMenuItem) {
                            RadioMenuItem radioMenuItem = (RadioMenuItem)menuItem;
                            if (radioMenuItem.getToggleGroup() == null) {
                                radioMenuItem.setSelected(!radioMenuItem.isSelected());
                            } else {
                                radioMenuItem.setSelected(true);
                            }
                        } else if (menuItem instanceof CheckMenuItem) {
                            ((CheckMenuItem)menuItem).setSelected(!((CheckMenuItem)menuItem).isSelected());
                        }
                        menuItem.fire();
                    }
                };
                observableMap.put(menuItem.getAccelerator(), runnable);
            }
            menuItem.acceleratorProperty().addListener(ControlAcceleratorSupport.getListener(scene2, menuItem));
        }
    }

    private static ChangeListener<KeyCombination> getListener(Scene scene2, MenuItem menuItem) {
        ChangeListener<KeyCombination> changeListener;
        WeakReference<ChangeListener<KeyCombination>> weakReference = changeListenerMap.get(menuItem);
        ChangeListener<KeyCombination> changeListener2 = changeListener = weakReference == null ? null : (ChangeListener<KeyCombination>)weakReference.get();
        if (changeListener == null) {
            changeListener = (observableValue, keyCombination, keyCombination2) -> {
                ObservableMap<KeyCombination, Runnable> observableMap = scene2.getAccelerators();
                Runnable runnable = (Runnable)observableMap.remove(keyCombination);
                if (keyCombination2 != null) {
                    observableMap.put((KeyCombination)keyCombination2, runnable);
                }
            };
            changeListenerMap.put(menuItem, new WeakReference<ChangeListener<KeyCombination>>(changeListener));
        }
        return changeListener;
    }

    public static void removeAcceleratorsFromScene(ObservableList<? extends MenuItem> observableList, Tab tab) {
        TabPane tabPane = tab.getTabPane();
        if (tabPane == null) {
            return;
        }
        Scene scene2 = tabPane.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(observableList, scene2);
    }

    public static void removeAcceleratorsFromScene(ObservableList<? extends MenuItem> observableList, TableColumnBase<?, ?> tableColumnBase) {
        ReadOnlyObjectProperty<? extends Control> readOnlyObjectProperty = ControlAcceleratorSupport.getControlProperty(tableColumnBase);
        if (readOnlyObjectProperty == null) {
            return;
        }
        Control control = (Control)readOnlyObjectProperty.get();
        if (control == null) {
            return;
        }
        Scene scene2 = control.getScene();
        ControlAcceleratorSupport.removeAcceleratorsFromScene(observableList, scene2);
    }

    public static void removeAcceleratorsFromScene(ObservableList<? extends MenuItem> observableList, Node node) {
        WeakReference<ChangeListener<Scene>> weakReference;
        Scene scene2 = node.getScene();
        if (scene2 == null && (weakReference = sceneChangeListenerMap.get(node)) != null) {
            ChangeListener changeListener = (ChangeListener)weakReference.get();
            if (changeListener != null) {
                node.sceneProperty().removeListener(changeListener);
            }
            sceneChangeListenerMap.remove(node);
        }
        ControlAcceleratorSupport.removeAcceleratorsFromScene(observableList, scene2);
    }

    public static void removeAcceleratorsFromScene(ObservableList<? extends MenuItem> observableList, Scene scene2) {
        ListChangeListener listChangeListener;
        WeakReference<ListChangeListener<MenuItem>> weakReference = menuListChangeListenerMap.get(new IdentityWrapperListChangeListener(observableList));
        if (weakReference != null && (listChangeListener = (ListChangeListener)weakReference.get()) != null) {
            observableList.removeListener(listChangeListener);
        }
        ControlAcceleratorSupport.removeAcceleratorsFromScene(observableList, scene2);
    }

    private static void removeAcceleratorsFromScene(List<? extends MenuItem> list, Scene scene2) {
        if (scene2 == null) {
            return;
        }
        for (MenuItem menuItem : list) {
            if (menuItem instanceof Menu) {
                ControlAcceleratorSupport.removeAcceleratorsFromScene(((Menu)menuItem).getItems(), scene2);
                continue;
            }
            ObservableMap<KeyCombination, Runnable> observableMap = scene2.getAccelerators();
            observableMap.remove(menuItem.getAccelerator());
            WeakReference<ChangeListener<KeyCombination>> weakReference = changeListenerMap.get(menuItem);
            if (weakReference == null) continue;
            ChangeListener changeListener = (ChangeListener)weakReference.get();
            if (changeListener != null) {
                menuItem.acceleratorProperty().removeListener(changeListener);
            }
            changeListenerMap.remove(menuItem);
        }
    }

    private static ReadOnlyObjectProperty<? extends Control> getControlProperty(Object object) {
        if (object instanceof TableColumn) {
            return ((TableColumn)object).tableViewProperty();
        }
        if (object instanceof TreeTableColumn) {
            return ((TreeTableColumn)object).treeTableViewProperty();
        }
        if (object instanceof Tab) {
            return ((Tab)object).tabPaneProperty();
        }
        return null;
    }

    static class IdentityWrapperListChangeListener
    implements ListChangeListener<MenuItem> {
        ObservableList<? extends MenuItem> innerList;

        public IdentityWrapperListChangeListener(ObservableList<? extends MenuItem> observableList) {
            this.innerList = observableList;
        }

        @Override
        public void onChanged(ListChangeListener.Change<? extends MenuItem> change) {
        }

        public int hashCode() {
            return System.identityHashCode(this.innerList);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof IdentityWrapperListChangeListener)) {
                return false;
            }
            IdentityWrapperListChangeListener identityWrapperListChangeListener = (IdentityWrapperListChangeListener)object;
            return this.innerList == identityWrapperListChangeListener.innerList;
        }
    }
}

