/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.scene.NodeHelper;
import javafx.beans.property.ReadOnlyBooleanPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;

public class TreeShowingProperty
extends ReadOnlyBooleanPropertyBase {
    private final ChangeListener<Boolean> windowShowingChangedListener = (observableValue, bl, bl2) -> this.updateTreeShowing();
    private final ChangeListener<Window> sceneWindowChangedListener = (observableValue, window2, window3) -> this.windowChanged((Window)window2, (Window)window3);
    private final ChangeListener<Scene> nodeSceneChangedListener = (observableValue, scene2, scene3) -> this.sceneChanged((Scene)scene2, (Scene)scene3);
    private final Node node;
    private boolean valid;
    private boolean treeShowing;

    public TreeShowingProperty(Node node) {
        this.node = node;
        this.node.sceneProperty().addListener(this.nodeSceneChangedListener);
        NodeHelper.treeVisibleProperty(node).addListener(this.windowShowingChangedListener);
        this.sceneChanged(null, node.getScene());
    }

    @Override
    public Object getBean() {
        return this.node;
    }

    @Override
    public String getName() {
        return "treeShowing";
    }

    public void dispose() {
        this.node.sceneProperty().removeListener(this.nodeSceneChangedListener);
        NodeHelper.treeVisibleProperty(this.node).removeListener(this.windowShowingChangedListener);
        this.valid = false;
        this.sceneChanged(this.node.getScene(), null);
    }

    protected void invalidate() {
        if (this.valid) {
            this.valid = false;
            this.fireValueChangedEvent();
        }
    }

    @Override
    public boolean get() {
        if (!this.valid) {
            this.updateTreeShowing();
            this.valid = true;
        }
        return this.treeShowing;
    }

    private void sceneChanged(Scene scene2, Scene scene3) {
        if (scene2 != null) {
            scene2.windowProperty().removeListener(this.sceneWindowChangedListener);
        }
        if (scene3 != null) {
            scene3.windowProperty().addListener(this.sceneWindowChangedListener);
        }
        this.windowChanged(scene2 == null ? null : scene2.getWindow(), scene3 == null ? null : scene3.getWindow());
    }

    private void windowChanged(Window window2, Window window3) {
        if (window2 != null) {
            window2.showingProperty().removeListener(this.windowShowingChangedListener);
        }
        if (window3 != null) {
            window3.showingProperty().addListener(this.windowShowingChangedListener);
        }
        this.updateTreeShowing();
    }

    private void updateTreeShowing() {
        boolean bl = NodeHelper.isTreeShowing(this.node);
        if (bl != this.treeShowing) {
            this.treeShowing = bl;
            this.invalidate();
        }
    }
}

