/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.scene.CameraHelper;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SceneHelper;
import com.sun.javafx.scene.SubSceneHelper;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.SubScene;

public class SceneUtils {
    public static Point3D subSceneToScene(SubScene subScene2, Point3D point3D) {
        SubScene subScene3 = subScene2;
        while (subScene3 != null) {
            Point2D point2D = CameraHelper.project(SubSceneHelper.getEffectiveCamera(subScene2), point3D);
            point3D = subScene3.localToScene(point2D.getX(), point2D.getY(), 0.0);
            subScene3 = NodeHelper.getSubScene(subScene3);
        }
        return point3D;
    }

    public static Point2D sceneToSubScenePlane(SubScene subScene2, Point2D point2D) {
        point2D = SceneUtils.computeSubSceneCoordinates(point2D.getX(), point2D.getY(), subScene2);
        return point2D;
    }

    private static Point2D computeSubSceneCoordinates(double d, double d2, SubScene subScene2) {
        SubScene subScene3 = NodeHelper.getSubScene(subScene2);
        if (subScene3 == null) {
            return CameraHelper.pickNodeXYPlane(SceneHelper.getEffectiveCamera(subScene2.getScene()), subScene2, d, d2);
        }
        Point2D point2D = SceneUtils.computeSubSceneCoordinates(d, d2, subScene3);
        if (point2D != null) {
            point2D = CameraHelper.pickNodeXYPlane(SubSceneHelper.getEffectiveCamera(subScene3), subScene2, point2D.getX(), point2D.getY());
        }
        return point2D;
    }
}

