/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.iio.common;

import com.sun.javafx.iio.common.PushbroomScaler;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SmoothMinifier
implements PushbroomScaler {
    protected int sourceWidth;
    protected int sourceHeight;
    protected int numBands;
    protected int destWidth;
    protected int destHeight;
    protected double scaleY;
    protected ByteBuffer destBuf;
    protected int boxHeight;
    protected byte[][] sourceData;
    protected int[] leftPoints;
    protected int[] rightPoints;
    protected int[] topPoints;
    protected int[] bottomPoints;
    protected int sourceLine;
    protected int sourceDataLine;
    protected int destLine;
    protected int[] tmpBuf;

    SmoothMinifier(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (n <= 0 || n2 <= 0 || n3 <= 0 || n4 <= 0 || n5 <= 0 || n4 > n || n5 > n2) {
            throw new IllegalArgumentException();
        }
        this.sourceWidth = n;
        this.sourceHeight = n2;
        this.numBands = n3;
        this.destWidth = n4;
        this.destHeight = n5;
        this.destBuf = ByteBuffer.wrap(new byte[n5 * n4 * n3]);
        double d = (double)n / (double)n4;
        this.scaleY = (double)n2 / (double)n5;
        int n8 = (n + n4 - 1) / n4;
        this.boxHeight = (n2 + n5 - 1) / n5;
        int n9 = n8 / 2;
        int n10 = n8 - n9 - 1;
        int n11 = this.boxHeight / 2;
        int n12 = this.boxHeight - n11 - 1;
        this.sourceData = new byte[this.boxHeight][n4 * n3];
        this.leftPoints = new int[n4];
        this.rightPoints = new int[n4];
        for (n7 = 0; n7 < n4; ++n7) {
            n6 = (int)((double)n7 * d);
            this.leftPoints[n7] = n6 - n9;
            this.rightPoints[n7] = n6 + n10;
        }
        this.topPoints = new int[n5];
        this.bottomPoints = new int[n5];
        for (n7 = 0; n7 < n5; ++n7) {
            n6 = (int)((double)n7 * this.scaleY);
            this.topPoints[n7] = n6 - n11;
            this.bottomPoints[n7] = n6 + n12;
        }
        this.sourceLine = 0;
        this.sourceDataLine = 0;
        this.destLine = 0;
        this.tmpBuf = new int[n4 * n3];
    }

    @Override
    public ByteBuffer getDestination() {
        return this.destBuf;
    }

    @Override
    public boolean putSourceScanline(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (n < 0) {
            throw new IllegalArgumentException("off < 0!");
        }
        if (this.numBands == 1) {
            var3_3 = byArray[n] & 0xFF;
            n6 = byArray[n + this.sourceWidth - 1] & 0xFF;
            for (n5 = 0; n5 < this.destWidth; ++n5) {
                n4 = 0;
                var7_8 = this.rightPoints[n5];
                for (n3 = this.leftPoints[n5]; n3 <= var7_8; ++n3) {
                    if (n3 < 0) {
                        n4 += var3_3;
                        continue;
                    }
                    if (n3 >= this.sourceWidth) {
                        n4 += n6;
                        continue;
                    }
                    n4 += byArray[n + n3] & 0xFF;
                }
                this.sourceData[this.sourceDataLine][n5] = (byte)(n4 /= var7_8 - this.leftPoints[n5] + 1);
            }
        } else {
            var3_3 = n + (this.sourceWidth - 1) * this.numBands;
            for (n6 = 0; n6 < this.destWidth; ++n6) {
                n5 = this.leftPoints[n6];
                n4 = this.rightPoints[n6];
                var7_8 = n4 - n5 + 1;
                n3 = n6 * this.numBands;
                for (n2 = 0; n2 < this.numBands; ++n2) {
                    int n7 = byArray[n + n2] & 0xFF;
                    int n8 = byArray[var3_3 + n2] & 0xFF;
                    int n9 = 0;
                    for (int j = n5; j <= n4; ++j) {
                        if (j < 0) {
                            n9 += n7;
                            continue;
                        }
                        if (j >= this.sourceWidth) {
                            n9 += n8;
                            continue;
                        }
                        n9 += byArray[n + j * this.numBands + n2] & 0xFF;
                    }
                    this.sourceData[this.sourceDataLine][n3 + n2] = (byte)(n9 /= var7_8);
                }
            }
        }
        if (this.sourceLine == this.bottomPoints[this.destLine] || this.destLine == this.destHeight - 1 && this.sourceLine == this.sourceHeight - 1) {
            assert (this.destBuf.hasArray()) : "destBuf.hasArray() == false => destBuf is direct";
            byte[] byArray2 = this.destBuf.array();
            n6 = this.destLine * this.destWidth * this.numBands;
            Arrays.fill(this.tmpBuf, 0);
            for (n5 = this.topPoints[this.destLine]; n5 <= this.bottomPoints[this.destLine]; ++n5) {
                n4 = 0;
                n4 = n5 < 0 ? 0 - this.sourceLine + this.sourceDataLine : (n5 >= this.sourceHeight ? (this.sourceHeight - 1 - this.sourceLine + this.sourceDataLine) % this.boxHeight : (n5 - this.sourceLine + this.sourceDataLine) % this.boxHeight);
                if (n4 < 0) {
                    n4 += this.boxHeight;
                }
                byte[] byArray3 = this.sourceData[n4];
                n3 = byArray3.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    int n10 = n2;
                    this.tmpBuf[n10] = this.tmpBuf[n10] + (byArray3[n2] & 0xFF);
                }
            }
            n5 = this.tmpBuf.length;
            for (n4 = 0; n4 < n5; ++n4) {
                byArray2[n6 + n4] = (byte)(this.tmpBuf[n4] / this.boxHeight);
            }
            if (this.destLine < this.destHeight - 1) {
                ++this.destLine;
            }
        }
        if (++this.sourceLine != this.sourceHeight) {
            this.sourceDataLine = (this.sourceDataLine + 1) % this.boxHeight;
        }
        return this.destLine == this.destHeight;
    }
}

