/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.attach.util.impl;

import com.gluonhq.attach.util.Util;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;

public class ClipboardUtils {
    private static final Logger LOGGER = Logger.getLogger(ClipboardUtils.class.getName());
    private static String content;

    public ClipboardUtils() {
        if (Util.DEBUG) {
            LOGGER.info("Init Util::ClipboardUtils");
        }
    }

    private static String syncClipboardToOS() {
        if (Util.DEBUG) {
            LOGGER.info("Util::ClipboardUtils syncClipboardToOS");
        }
        content = null;
        try {
            CountDownLatch latch = new CountDownLatch(1);
            Platform.runLater(() -> {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                if (clipboard.hasString()) {
                    content = clipboard.getString();
                }
                latch.countDown();
            });
            latch.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return content;
    }

    private static void syncClipboardFromOS(String text) {
        if (Util.DEBUG) {
            LOGGER.info("Util::ClipboardUtils syncClipboardFromOS");
        }
        if (text != null && !text.isEmpty()) {
            Platform.runLater(() -> {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putString(text);
                clipboard.setContent(content);
            });
        }
    }
}

