/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient.utils;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.utils.I18nLoader;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.jetbrains.annotations.NotNull;

public class SimpleTextPopup {
    public void displayPopup(@NotNull Text text) {
        VBox popupBox = new VBox(20.0);
        popupBox.getStyleClass().add("simpleTextPopup");
        HBox closeButton = new HBox();
        closeButton.setAlignment(Pos.BASELINE_CENTER);
        text.setTextAlignment(TextAlignment.CENTER);
        text.setFont(Font.font("Courier New", FontWeight.BOLD, 20.0));
        Button toCloseButton = new Button(I18nLoader.getText("close"));
        toCloseButton.getStyleClass().add("simpleTextPopup-close-button");
        toCloseButton.setOnAction(event -> FXGL.getGameScene().removeUINode(popupBox));
        closeButton.getChildren().add(toCloseButton);
        popupBox.getChildren().addAll((Node[])new Node[]{text, closeButton});
        popupBox.getStylesheets().add(Objects.requireNonNull(this.getClass().getResource("/assets/ui/general.css")).toExternalForm());
        popupBox.setTranslateX((double)FXGL.getAppWidth() / 2.0 - 250.0);
        popupBox.setTranslateY((double)FXGL.getAppHeight() / 2.0 - 50.0);
        FXGL.getGameScene().addUINode(popupBox);
    }
}

