/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient.utils;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.utils.I18nLoader;
import java.util.Objects;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.jetbrains.annotations.NotNull;

public class SimpleConfirmationPopup {
    public void displayPopup(@NotNull Text text, Consumer<Boolean> callback) {
        VBox popupBox = new VBox(20.0);
        popupBox.getStyleClass().add("simpleConfirmationPopup");
        HBox buttonBox = new HBox(40.0);
        buttonBox.setAlignment(Pos.BASELINE_CENTER);
        text.setTextAlignment(TextAlignment.CENTER);
        text.setFont(Font.font("Courier New", FontWeight.BOLD, 20.0));
        Button toConfirmButton = new Button(I18nLoader.getText("gameExit.yes"));
        toConfirmButton.getStyleClass().add("gameExit-confirm-button");
        Button toCancelButton = new Button(I18nLoader.getText("gameExit.no"));
        toCancelButton.getStyleClass().add("gameExit-cancel-button");
        toConfirmButton.setOnAction(event -> {
            FXGL.getGameScene().removeUINode(popupBox);
            callback.accept(true);
        });
        toCancelButton.setOnAction(event -> {
            FXGL.getGameScene().removeUINode(popupBox);
            callback.accept(false);
        });
        buttonBox.getChildren().addAll((Node[])new Node[]{toConfirmButton, toCancelButton});
        popupBox.getChildren().addAll((Node[])new Node[]{text, buttonBox});
        popupBox.getStylesheets().add(Objects.requireNonNull(this.getClass().getResource("/assets/ui/general.css")).toExternalForm());
        popupBox.setTranslateX((double)FXGL.getAppWidth() / 2.0 - 250.0);
        popupBox.setTranslateY((double)FXGL.getAppHeight() / 2.0 - 60.0);
        FXGL.getGameScene().addUINode(popupBox);
    }
}

