/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient.scenes;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.ApiService;
import com.battleshipclient.SceneManager;
import com.battleshipclient.UserOverlay;
import com.battleshipclient.WebSocketClientService;
import com.battleshipclient.status.UserStatus;
import com.battleshipclient.utils.I18nLoader;
import com.battleshipclient.utils.SimpleTextPopup;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class SignUpScene {
    private final WebSocketClientService webSocketService;
    private TextField usernameInput;
    private PasswordField passwordInput;
    private PasswordField passwordInputRepeat;
    private final Pane root;

    public SignUpScene(SceneManager sceneManager, WebSocketClientService webSocketService) {
        this.webSocketService = webSocketService;
        VBox header = this.setHeaderBoxParameters(new VBox(20.0));
        VBox input = this.setSignUpInputParameters(new VBox(40.0));
        HBox navigation = this.setNavigationButtons(new HBox(40.0), sceneManager);
        this.root = this.setScene(header, input, navigation);
    }

    @NotNull
    private AnchorPane setScene(VBox header, VBox input, HBox navigation) {
        AnchorPane anchoredLayout = new AnchorPane();
        anchoredLayout.getChildren().add(this.setBackgroundImage());
        anchoredLayout.getChildren().addAll((Node[])new Node[]{header, input, navigation});
        AnchorPane.setTopAnchor(header, 20.0);
        AnchorPane.setLeftAnchor(header, 0.0);
        AnchorPane.setRightAnchor(header, 0.0);
        AnchorPane.setBottomAnchor(navigation, 20.0);
        AnchorPane.setRightAnchor(navigation, 20.0);
        AnchorPane.setLeftAnchor(input, 0.0);
        AnchorPane.setRightAnchor(input, 0.0);
        AnchorPane.setTopAnchor(input, 100.0);
        AnchorPane.setBottomAnchor(input, 50.0);
        anchoredLayout.prefWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        anchoredLayout.prefHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        anchoredLayout.getStylesheets().add(Objects.requireNonNull(this.getClass().getResource("/assets/ui/signUp.css")).toExternalForm());
        return anchoredLayout;
    }

    @NotNull
    private ImageView setBackgroundImage() {
        Image backgroundImage = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/AccountScenes_Background.jpg")).toExternalForm());
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.fitWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        backgroundView.fitHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        return backgroundView;
    }

    @NotNull
    @Contract(value="_ -> param1")
    private VBox setHeaderBoxParameters(@NotNull VBox box) {
        box.setAlignment(Pos.TOP_CENTER);
        Text title = new Text(I18nLoader.getText("appTitle"));
        title.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 60.0));
        title.setTextAlignment(TextAlignment.CENTER);
        Text subTitle = new Text(I18nLoader.getText("scene.title.signUp"));
        subTitle.setFont(Font.font("Courier New", FontWeight.BOLD, 40.0));
        subTitle.setTextAlignment(TextAlignment.CENTER);
        box.getChildren().addAll((Node[])new Node[]{title, subTitle});
        return box;
    }

    @NotNull
    private VBox setSignUpInputParameters(@NotNull VBox box) {
        box.setAlignment(Pos.CENTER);
        HBox usernameBox = new HBox(20.0);
        usernameBox.setAlignment(Pos.CENTER);
        HBox passwordBox = new HBox(20.0);
        passwordBox.setAlignment(Pos.CENTER);
        HBox passwordRepeatBox = new HBox(20.0);
        passwordRepeatBox.setAlignment(Pos.CENTER);
        Text usernameTitle = new Text(I18nLoader.getText("username.title"));
        usernameTitle.setFont(Font.font("Courier New", FontWeight.BOLD, 30.0));
        usernameTitle.setWrappingWidth(300.0);
        usernameTitle.setTextAlignment(TextAlignment.RIGHT);
        this.usernameInput = new TextField();
        this.usernameInput.getStyleClass().add("inputField");
        usernameBox.getChildren().addAll((Node[])new Node[]{usernameTitle, this.usernameInput});
        Text passwordTitle = new Text(I18nLoader.getText("password.title"));
        passwordTitle.setFont(Font.font("Courier New", FontWeight.BOLD, 30.0));
        passwordTitle.setWrappingWidth(300.0);
        passwordTitle.setTextAlignment(TextAlignment.RIGHT);
        this.passwordInput = new PasswordField();
        this.passwordInput.getStyleClass().add("inputField");
        passwordBox.getChildren().setAll((Node[])new Node[]{passwordTitle, this.passwordInput});
        Text passwordRepeatTitle = new Text(I18nLoader.getText("passwordRepeat.title"));
        passwordRepeatTitle.setFont(Font.font("Courier New", FontWeight.BOLD, 30.0));
        passwordRepeatTitle.setWrappingWidth(300.0);
        passwordRepeatTitle.setTextAlignment(TextAlignment.RIGHT);
        this.passwordInputRepeat = new PasswordField();
        this.passwordInputRepeat.getStyleClass().add("inputField");
        passwordRepeatBox.getChildren().setAll((Node[])new Node[]{passwordRepeatTitle, this.passwordInputRepeat});
        box.getChildren().addAll((Node[])new Node[]{usernameBox, passwordBox, passwordRepeatBox});
        return box;
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    private HBox setNavigationButtons(@NotNull HBox box, SceneManager sceneManager) {
        box.setAlignment(Pos.BOTTOM_RIGHT);
        Button toLoginButton = new Button(I18nLoader.getText("scene.title.signUp"));
        toLoginButton.setOnAction(event -> this.verifySignUp(sceneManager));
        toLoginButton.getStyleClass().add("green-button");
        Button toCancelButton = new Button(I18nLoader.getText("return"));
        toCancelButton.setOnAction(event -> {
            sceneManager.showHomeScene(false);
            this.clearInputFields();
        });
        toCancelButton.getStyleClass().add("default-button");
        box.getChildren().addAll((Node[])new Node[]{toCancelButton, toLoginButton});
        return box;
    }

    private void verifySignUp(SceneManager sceneManager) {
        SimpleTextPopup signUpErrorPopup = new SimpleTextPopup();
        if (!this.passwordInput.getText().trim().equals(this.passwordInputRepeat.getText().trim())) {
            this.usernameInput.getStyleClass().add("inputField-error");
            this.passwordInput.getStyleClass().add("inputField-error");
            this.passwordInputRepeat.getStyleClass().add("inputField-error");
            Text errorText = new Text(I18nLoader.getText("signUp.input.passwords.notEqual"));
            signUpErrorPopup.displayPopup(errorText);
        } else if (this.usernameInput.getText().trim().length() > 12) {
            this.usernameInput.getStyleClass().add("inputField-error");
            Text errorText = new Text(I18nLoader.getText("signUp.input.username.toLong"));
            signUpErrorPopup.displayPopup(errorText);
        } else {
            ApiService.registerUser(this.usernameInput.getText(), this.passwordInput.getText());
            if (!Objects.equals(UserStatus.getAccessToken(), "")) {
                UserOverlay.initOverlay(true, this.usernameInput.getText().trim());
                sceneManager.showHomeScene(true);
                UserOverlay.showOverlay();
                this.clearInputFields();
                this.webSocketService.connect();
            } else {
                this.usernameInput.getStyleClass().add("inputField-error");
                Text errorText = new Text(I18nLoader.getText("signUp.input.username.exists"));
                signUpErrorPopup.displayPopup(errorText);
            }
        }
    }

    private void clearInputFields() {
        this.usernameInput.getStyleClass().remove("inputField-error");
        this.passwordInput.getStyleClass().remove("inputField-error");
        this.passwordInputRepeat.getStyleClass().remove("inputField-error");
        this.usernameInput.clear();
        this.passwordInput.clear();
        this.passwordInputRepeat.clear();
    }

    public Pane getRoot() {
        return this.root;
    }
}

