/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient.scenes;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.ApiService;
import com.battleshipclient.SceneManager;
import com.battleshipclient.UserOverlay;
import com.battleshipclient.WebSocketClientService;
import com.battleshipclient.enums.HitType;
import com.battleshipclient.status.GameStatus;
import com.battleshipclient.status.UserStatus;
import com.battleshipclient.utils.I18nLoader;
import com.battleshipclient.utils.SimpleConfirmationPopup;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.PauseTransition;
import javafx.animation.Timeline;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PlayGameScene {
    private final SceneManager sceneManager;
    private final Set<StackPane> lockedCells = new HashSet<StackPane>();
    private final Pane root;
    private GridPane myBoard;
    private Button toMakeHit;
    private StackPane selectedCell = null;
    private Circle currentDot = null;
    private int hitPosX;
    private int hitPosY;
    private Text notificationText;
    private ImageView imageViewOfShipOfCurrentType;
    private Text counterTextOfShipsOfCurrentType;
    private int currentSelectedShipSize;
    private boolean currentSelectedShipIsVertical;
    private boolean currentSelectedShipIsPlaced;
    private int currentPlacedShipRow;
    private int currentPlacedShipCol;
    private final HBox shipSelectionBox;

    public PlayGameScene(SceneManager sceneManager, WebSocketClientService webSocketService) {
        this.sceneManager = sceneManager;
        UserStatus.setInGameStatus(true);
        VBox header = this.setHeaderBoxParameters(new VBox(20.0));
        HBox fields = this.setFieldsBoxParameters(new HBox(200.0));
        this.shipSelectionBox = new HBox(30.0);
        this.setShipPlaceholder();
        HBox actionButtons = this.setActionButtons(new HBox(40.0), sceneManager);
        this.root = this.setScene(header, fields, actionButtons);
        this.placeShips(2);
        this.setOpponentTurnNotification(GameStatus.getIsMyTurnValue());
        GameStatus.getIsMyTurn().addListener((ignore, ignoredValue, newVal) -> this.setOpponentTurnNotification((boolean)newVal));
        webSocketService.setPlayGameScene(this);
    }

    @NotNull
    private AnchorPane setScene(VBox header, HBox fields, HBox actionButtons) {
        AnchorPane anchoredLayout = new AnchorPane();
        anchoredLayout.getChildren().add(this.setBackgroundImage());
        anchoredLayout.getChildren().addAll((Node[])new Node[]{header, fields, actionButtons, this.shipSelectionBox});
        AnchorPane.setTopAnchor(header, 20.0);
        AnchorPane.setLeftAnchor(header, 0.0);
        AnchorPane.setRightAnchor(header, 0.0);
        AnchorPane.setTopAnchor(fields, 200.0);
        AnchorPane.setLeftAnchor(fields, 0.0);
        AnchorPane.setRightAnchor(fields, 0.0);
        AnchorPane.setBottomAnchor(actionButtons, 20.0);
        AnchorPane.setRightAnchor(actionButtons, 20.0);
        AnchorPane.setLeftAnchor(this.shipSelectionBox, 300.0);
        AnchorPane.setBottomAnchor(this.shipSelectionBox, 40.0);
        anchoredLayout.prefWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        anchoredLayout.prefHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        anchoredLayout.getStylesheets().add(Objects.requireNonNull(this.getClass().getResource("/assets/ui/inGame.css")).toExternalForm());
        return anchoredLayout;
    }

    @NotNull
    private ImageView setBackgroundImage() {
        Image backgroundImage = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/GameBoard_Background.jpg")).toExternalForm());
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.fitWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        backgroundView.fitHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        return backgroundView;
    }

    @NotNull
    @Contract(value="_ -> param1")
    private VBox setHeaderBoxParameters(@NotNull VBox box) {
        box.setAlignment(Pos.TOP_CENTER);
        Text title = new Text(UserStatus.getUsername() + "  " + I18nLoader.getText("inGame.versus") + "  " + GameStatus.getOpponentUserName());
        title.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 60.0));
        title.setTextAlignment(TextAlignment.CENTER);
        title.getStyleClass().add("board-text");
        this.notificationText = new Text();
        this.notificationText.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 30.0));
        this.notificationText.setTextAlignment(TextAlignment.CENTER);
        box.getChildren().addAll((Node[])new Node[]{title, this.notificationText});
        return box;
    }

    @NotNull
    @Contract(value="_ -> param1")
    private HBox setFieldsBoxParameters(@NotNull HBox box) {
        box.setAlignment(Pos.CENTER);
        VBox myBoard = new VBox(10.0);
        myBoard.setAlignment(Pos.CENTER);
        Text myBoardTitle = new Text(I18nLoader.getText("inGame.myBoard"));
        myBoardTitle.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 20.0));
        myBoardTitle.setTextAlignment(TextAlignment.CENTER);
        myBoardTitle.getStyleClass().add("board-text");
        myBoard.getChildren().addAll((Node[])new Node[]{this.setMyBoard(), myBoardTitle});
        VBox opponentBoard = new VBox(10.0);
        opponentBoard.setAlignment(Pos.CENTER);
        Text opponentBoardTitle = new Text(I18nLoader.getText("inGame.opponentBoard"));
        opponentBoardTitle.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 20.0));
        opponentBoardTitle.setTextAlignment(TextAlignment.CENTER);
        opponentBoardTitle.getStyleClass().add("board-text");
        opponentBoard.getChildren().addAll((Node[])new Node[]{this.setOpponentBoard(), opponentBoardTitle});
        box.getChildren().addAll((Node[])new Node[]{myBoard, opponentBoard});
        return box;
    }

    private GridPane setMyBoard() {
        this.myBoard = new GridPane();
        for (int col = 0; col <= 10; ++col) {
            ColumnConstraints colConstraints = new ColumnConstraints(40.0);
            colConstraints.setFillWidth(true);
            colConstraints.setHgrow(Priority.NEVER);
            this.myBoard.getColumnConstraints().add(colConstraints);
            RowConstraints rowConstraints = new RowConstraints(40.0);
            rowConstraints.setFillHeight(true);
            rowConstraints.setVgrow(Priority.NEVER);
            this.myBoard.getRowConstraints().add(rowConstraints);
            for (int row = 0; row <= 10; ++row) {
                StackPane cell = new StackPane();
                cell.setPrefSize(40.0, 40.0);
                cell.getStyleClass().add("board-cell");
                if (row == 0 && col == 0) {
                    cell.getStyleClass().remove("board-cell");
                } else if (row == 0) {
                    cell.getStyleClass().remove("board-cell");
                    Label label = new Label(String.valueOf(col));
                    label.getStyleClass().add("board-label");
                    cell.getChildren().add(label);
                } else if (col == 0) {
                    cell.getStyleClass().remove("board-cell");
                    Label label = new Label(String.valueOf((char)(65 + row - 1)));
                    label.getStyleClass().add("board-label");
                    cell.getChildren().add(label);
                } else {
                    int selectedCol = col;
                    int selectedRow = row;
                    cell.setOnMouseClicked(event -> {
                        if (!GameStatus.allShipsSet()) {
                            boolean outOfBounds = this.currentSelectedShipIsVertical ? selectedRow + this.currentSelectedShipSize - 1 > 10 : selectedCol + this.currentSelectedShipSize - 1 > 10;
                            boolean canPlace = GameStatus.canPlaceShip(this.currentSelectedShipSize, this.currentSelectedShipIsVertical, selectedCol - 1, selectedRow - 1);
                            if (outOfBounds || !canPlace) {
                                this.notificationText.setFill(Color.RED);
                                this.notificationText.setText(I18nLoader.getText("inGame.notification.shipPlacement.invalid"));
                            } else {
                                this.currentPlacedShipRow = selectedRow;
                                this.currentPlacedShipCol = selectedCol;
                                this.currentSelectedShipIsPlaced = true;
                            }
                        }
                    });
                }
                this.myBoard.add(cell, col, row);
            }
        }
        return this.myBoard;
    }

    @NotNull
    private GridPane setOpponentBoard() {
        GridPane opponentBoard = new GridPane();
        for (int col = 0; col <= 10; ++col) {
            ColumnConstraints colConstraints = new ColumnConstraints(40.0);
            colConstraints.setFillWidth(true);
            colConstraints.setHgrow(Priority.NEVER);
            opponentBoard.getColumnConstraints().add(colConstraints);
            RowConstraints rowConstraints = new RowConstraints(40.0);
            rowConstraints.setFillHeight(true);
            rowConstraints.setVgrow(Priority.NEVER);
            opponentBoard.getRowConstraints().add(rowConstraints);
            for (int row = 0; row <= 10; ++row) {
                StackPane cell = new StackPane();
                cell.setPrefSize(40.0, 40.0);
                cell.getStyleClass().add("board-cell");
                if (row == 0 && col == 0) {
                    cell.getStyleClass().remove("board-cell");
                } else if (row == 0) {
                    cell.getStyleClass().remove("board-cell");
                    Label label = new Label(String.valueOf(col));
                    label.getStyleClass().add("board-label");
                    cell.getChildren().add(label);
                } else if (col == 0) {
                    cell.getStyleClass().remove("board-cell");
                    Label label = new Label(String.valueOf((char)(65 + row - 1)));
                    label.getStyleClass().add("board-label");
                    cell.getChildren().add(label);
                } else {
                    int finalCol = col;
                    int finalRow = row;
                    cell.setOnMouseClicked(event -> {
                        this.hitPosX = finalCol - 1;
                        this.hitPosY = finalRow - 1;
                        if (this.lockedCells.contains(cell) || !GameStatus.getIsMyTurnValue() || !GameStatus.allShipsSet() || !GameStatus.allShipsSetOpponent()) {
                            return;
                        }
                        if (this.selectedCell != null && this.currentDot != null) {
                            this.selectedCell.getChildren().remove(this.currentDot);
                        }
                        this.selectedCell = cell;
                        this.currentDot = new Circle(10.0, Color.GREY);
                        cell.getChildren().add(this.currentDot);
                        this.toMakeHit.setDisable(false);
                    });
                }
                opponentBoard.add(cell, col, row);
            }
        }
        return opponentBoard;
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    private HBox setActionButtons(@NotNull HBox box, SceneManager sceneManager) {
        box.setAlignment(Pos.BOTTOM_RIGHT);
        Button toSurrenderButton = new Button(I18nLoader.getText("inGame.surrender"));
        toSurrenderButton.setOnAction(event -> {
            Text confirmationText = new Text(I18nLoader.getText("inGame.surrender.confirm"));
            SimpleConfirmationPopup confirmationPopup = new SimpleConfirmationPopup();
            confirmationPopup.displayPopup(confirmationText, confirmed -> {
                if (confirmed.booleanValue()) {
                    ApiService.surrender();
                    UserStatus.setInGameStatus(false);
                    sceneManager.showHomeScene(true);
                    UserOverlay.showOverlay();
                    GameStatus.setGameKey(null);
                    GameStatus.setOpponentUserName(null);
                }
            });
        });
        toSurrenderButton.getStyleClass().add("red-button");
        this.toMakeHit = new Button(I18nLoader.getText("inGame.makeHit"));
        this.toMakeHit.setOnAction(event -> {
            if (this.selectedCell != null & this.currentDot != null) {
                this.toMakeHit.setDisable(true);
                ApiService.hit(this.hitPosX, this.hitPosY);
                if (GameStatus.getCurrentHitType() == HitType.HIT) {
                    this.notificationText.setText(I18nLoader.getText("inGame.notification.hit"));
                    this.notificationText.setFill(Color.LIGHTGREEN);
                } else if (GameStatus.getCurrentHitType() == HitType.DESTROYED) {
                    this.notificationText.setText(I18nLoader.getText("inGame.notification.shipDestroyed"));
                    this.notificationText.setFill(Color.LIGHTGREEN);
                } else if (GameStatus.getCurrentHitType() == HitType.WON) {
                    this.notificationText.setText(I18nLoader.getText("inGame.notification.won"));
                    this.notificationText.setFill(Color.LIGHTGREEN);
                    PauseTransition notificationTextPause = new PauseTransition(Duration.seconds(3.0));
                    notificationTextPause.setOnFinished(actionEvent -> {
                        UserStatus.setInGameStatus(false);
                        sceneManager.showHomeScene(true);
                        UserOverlay.showOverlay();
                        GameStatus.setGameKey(null);
                        GameStatus.setOpponentUserName(null);
                    });
                    notificationTextPause.play();
                } else if (GameStatus.getCurrentHitType() == HitType.MISS) {
                    GameStatus.setIsMyTurn(false);
                } else {
                    GameStatus.setIsMyTurn(false);
                }
                this.currentDot.setFill(GameStatus.getCurrentHitType() == HitType.HIT || GameStatus.getCurrentHitType() == HitType.DESTROYED || GameStatus.getCurrentHitType() == HitType.WON ? Color.RED : Color.WHITE);
                this.lockedCells.add(this.selectedCell);
                this.selectedCell = null;
                this.currentDot = null;
            }
        });
        this.toMakeHit.getStyleClass().add("green-button");
        this.toMakeHit.visibleProperty().bind(GameStatus.getIsMyTurn());
        box.getChildren().addAll((Node[])new Node[]{this.toMakeHit, toSurrenderButton});
        return box;
    }

    public void handleLose() {
        this.notificationText.setText(I18nLoader.getText("inGame.notification.lose"));
        this.notificationText.setFill(Color.RED);
        PauseTransition notificationTextPause = new PauseTransition(Duration.seconds(3.0));
        notificationTextPause.setOnFinished(event -> {
            UserStatus.setInGameStatus(false);
            this.sceneManager.showHomeScene(true);
            UserOverlay.showOverlay();
            GameStatus.setGameKey(null);
            GameStatus.setOpponentUserName(null);
        });
        notificationTextPause.play();
    }

    public void handleSurrender() {
        this.notificationText.setText(I18nLoader.getText("inGame.notification.opponentSurrendered"));
        this.notificationText.setFill(Color.RED);
        PauseTransition notificationTextPause = new PauseTransition(Duration.seconds(3.0));
        notificationTextPause.setOnFinished(event -> {
            UserStatus.setInGameStatus(false);
            this.sceneManager.showHomeScene(true);
            UserOverlay.showOverlay();
            GameStatus.setGameKey(null);
            GameStatus.setOpponentUserName(null);
        });
        notificationTextPause.play();
    }

    public void setOpponentTurnNotification(boolean isMyTurn) {
        if (!isMyTurn && GameStatus.allShipsSet() && GameStatus.allShipsSetOpponent()) {
            this.notificationText.setFill(Color.RED);
            this.notificationText.setText(I18nLoader.getText("inGame.notification.opponentTurn"));
        } else if (isMyTurn && GameStatus.allShipsSet() && GameStatus.allShipsSetOpponent()) {
            this.notificationText.setFill(Color.LIGHTGREEN);
            this.notificationText.setText(I18nLoader.getText("inGame.notification.myTurn"));
        }
    }

    private void setShipPlaceholder() {
        this.shipSelectionBox.setAlignment(Pos.CENTER);
        this.imageViewOfShipOfCurrentType = new ImageView();
        this.counterTextOfShipsOfCurrentType = new Text();
        this.counterTextOfShipsOfCurrentType.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 20.0));
        this.counterTextOfShipsOfCurrentType.setTextAlignment(TextAlignment.CENTER);
        this.counterTextOfShipsOfCurrentType.getStyleClass().add("board-text");
        Button toSetVerticalButton = new Button("H");
        toSetVerticalButton.getStyleClass().add("vertical-button");
        toSetVerticalButton.setOnAction(event -> {
            String oldText = toSetVerticalButton.getText();
            String newText = Objects.equals(oldText, "H") ? "V" : "H";
            this.currentSelectedShipIsVertical = Objects.equals(newText, "V");
            toSetVerticalButton.setText(newText);
        });
        this.shipSelectionBox.getChildren().addAll((Node[])new Node[]{this.imageViewOfShipOfCurrentType, this.counterTextOfShipsOfCurrentType, toSetVerticalButton});
    }

    private void placeShips(int size) {
        if (size > 5) {
            return;
        }
        this.notificationText.setFill(Color.YELLOW);
        this.notificationText.setText(I18nLoader.getText("inGame.notification.shipPlacement"));
        int counter = switch (size) {
            case 2 -> GameStatus.getNumberOfSize2ShipsToBeSet();
            case 3 -> GameStatus.getNumberOfSize3ShipsToBeSet();
            case 4 -> GameStatus.getNumberOfSize4ShipsToBeSet();
            case 5 -> GameStatus.getNumberOfSize5ShipsToBeSet();
            default -> 0;
        };
        if (counter == 0) {
            this.placeShips(size + 1);
        } else {
            this.currentSelectedShipSize = size;
            Image shipImage = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/ships/size_" + size + "_ship.png")).toExternalForm());
            this.imageViewOfShipOfCurrentType.setImage(shipImage);
            this.imageViewOfShipOfCurrentType.setFitWidth(40 * size);
            this.imageViewOfShipOfCurrentType.setFitHeight(40.0);
            ImageView shipImageInBoard = new ImageView(shipImage);
            shipImageInBoard.setFitWidth(40 * size);
            shipImageInBoard.setFitHeight(40.0);
            this.counterTextOfShipsOfCurrentType.setText(counter + "X");
            this.currentSelectedShipIsPlaced = false;
            Timeline waitForPlacement = new Timeline();
            waitForPlacement.getKeyFrames().add(new KeyFrame(Duration.millis(100.0), event -> {
                if (this.currentSelectedShipIsPlaced) {
                    int posX;
                    waitForPlacement.stop();
                    this.notificationText.setText("");
                    this.counterTextOfShipsOfCurrentType.setText(counter - 1 + "X");
                    int posY = this.currentSelectedShipIsVertical ? 1 : this.currentSelectedShipSize;
                    int n = posX = this.currentSelectedShipIsVertical ? this.currentSelectedShipSize : 1;
                    if (this.currentSelectedShipIsVertical) {
                        shipImageInBoard.setRotate(90.0);
                        shipImageInBoard.setFitWidth(40 * size);
                        shipImageInBoard.setFitHeight(40.0);
                        shipImageInBoard.setTranslateX((double)(-(40 * size - 40)) / 2.0);
                    }
                    this.myBoard.add(shipImageInBoard, this.currentPlacedShipCol, this.currentPlacedShipRow, posY, posX);
                    GameStatus.placeShip(this.currentSelectedShipSize, this.currentSelectedShipIsVertical, this.currentPlacedShipCol - 1, this.currentPlacedShipRow - 1);
                    this.placeShips(size);
                    if (GameStatus.allShipsSet()) {
                        this.shipSelectionBox.setVisible(false);
                        ApiService.setupBoard(GameStatus.getShips());
                        if (!GameStatus.allShipsSetOpponent()) {
                            this.notificationText.setFill(Color.LIGHTGREEN);
                            this.notificationText.setText(I18nLoader.getText("inGame.notification.shipPlacement.allShipsPlaced"));
                        }
                    }
                }
            }, new KeyValue[0]));
            waitForPlacement.setCycleCount(-1);
            waitForPlacement.play();
        }
    }

    public void setCrossOnField(int posX, int posY) {
        Image crossImage = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/cross.png")).toExternalForm());
        ImageView crossImageInBoard = new ImageView(crossImage);
        crossImageInBoard.setFitWidth(40.0);
        crossImageInBoard.setFitHeight(40.0);
        this.myBoard.add(crossImageInBoard, posX + 1, posY + 1);
    }

    public Pane getRoot() {
        return this.root;
    }
}

