/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient.scenes;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.ApiService;
import com.battleshipclient.SceneManager;
import com.battleshipclient.UserOverlay;
import com.battleshipclient.WebSocketClientService;
import com.battleshipclient.scenes.PlayGameScene;
import com.battleshipclient.status.GameStatus;
import com.battleshipclient.utils.I18nLoader;
import com.battleshipclient.utils.SimpleTextPopup;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class JoinGameScene {
    private final WebSocketClientService webSocketService;
    private TextField gameKeyInput;
    private final Pane root;

    public JoinGameScene(SceneManager sceneManager, WebSocketClientService webSocketService) {
        this.webSocketService = webSocketService;
        VBox header = this.setHeaderBoxParameters(new VBox(20.0));
        VBox input = this.setKeyParameter(new VBox(40.0));
        HBox navigation = this.setNavigationButtons(new HBox(40.0), sceneManager);
        this.root = this.setScene(header, input, navigation);
    }

    @NotNull
    private AnchorPane setScene(VBox header, VBox input, HBox navigation) {
        AnchorPane anchoredLayout = new AnchorPane();
        anchoredLayout.getChildren().add(this.setBackgroundImage());
        anchoredLayout.getChildren().addAll((Node[])new Node[]{header, input, navigation});
        AnchorPane.setTopAnchor(header, 20.0);
        AnchorPane.setLeftAnchor(header, 0.0);
        AnchorPane.setRightAnchor(header, 0.0);
        AnchorPane.setBottomAnchor(navigation, 20.0);
        AnchorPane.setRightAnchor(navigation, 20.0);
        AnchorPane.setLeftAnchor(input, 0.0);
        AnchorPane.setRightAnchor(input, 0.0);
        AnchorPane.setTopAnchor(input, 100.0);
        AnchorPane.setBottomAnchor(input, 50.0);
        anchoredLayout.prefWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        anchoredLayout.prefHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        anchoredLayout.getStylesheets().add(Objects.requireNonNull(this.getClass().getResource("/assets/ui/joinGame.css")).toExternalForm());
        return anchoredLayout;
    }

    @NotNull
    private ImageView setBackgroundImage() {
        Image backgroundImage = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/PreGameScenes_Background.jpg")).toExternalForm());
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.fitWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        backgroundView.fitHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        return backgroundView;
    }

    @NotNull
    @Contract(value="_ -> param1")
    private VBox setHeaderBoxParameters(@NotNull VBox box) {
        box.setAlignment(Pos.TOP_CENTER);
        Text title = new Text(I18nLoader.getText("appTitle"));
        title.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 60.0));
        title.setTextAlignment(TextAlignment.CENTER);
        Text subTitle = new Text(I18nLoader.getText("scene.title.joinGame"));
        subTitle.setFont(Font.font("Courier New", FontWeight.BOLD, 40.0));
        subTitle.setTextAlignment(TextAlignment.CENTER);
        box.getChildren().addAll((Node[])new Node[]{title, subTitle});
        return box;
    }

    @NotNull
    private VBox setKeyParameter(@NotNull VBox box) {
        box.setAlignment(Pos.CENTER);
        HBox gameKeyBox = new HBox(20.0);
        gameKeyBox.setAlignment(Pos.CENTER);
        Text gameKeyTitle = new Text(I18nLoader.getText("gameKey.title"));
        gameKeyTitle.setFont(Font.font("Courier New", FontWeight.BOLD, 30.0));
        this.gameKeyInput = new TextField();
        this.gameKeyInput.getStyleClass().add("inputField");
        gameKeyBox.getChildren().setAll((Node[])new Node[]{gameKeyTitle, this.gameKeyInput});
        box.getChildren().addAll((Node[])new Node[]{gameKeyBox});
        return box;
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    private HBox setNavigationButtons(@NotNull HBox box, SceneManager sceneManager) {
        box.setAlignment(Pos.BOTTOM_RIGHT);
        Button toJoinGameButton = new Button(I18nLoader.getText("joinGame"));
        toJoinGameButton.setOnAction(event -> this.verifyKeyAndStartGame(sceneManager));
        toJoinGameButton.getStyleClass().add("green-button");
        Button toCancelButton = new Button(I18nLoader.getText("return"));
        toCancelButton.setOnAction(event -> {
            this.clearInputFields();
            sceneManager.showHomeScene(true);
            UserOverlay.showOverlay();
        });
        toCancelButton.getStyleClass().add("default-button");
        box.getChildren().addAll((Node[])new Node[]{toCancelButton, toJoinGameButton});
        return box;
    }

    private void verifyKeyAndStartGame(SceneManager sceneManager) {
        ApiService.joinGame(this.gameKeyInput.getText());
        if (!Objects.equals(GameStatus.getOpponentUserName(), "")) {
            GameStatus.startGame(false);
            this.clearInputFields();
            PlayGameScene playGame = new PlayGameScene(sceneManager, this.webSocketService);
            FXGL.getGameScene().clearUINodes();
            FXGL.getGameScene().addUINode(playGame.getRoot());
        } else {
            this.gameKeyInput.getStyleClass().add("inputField-error");
            SimpleTextPopup invalidKeyErrorPopup = new SimpleTextPopup();
            Text errorText = new Text(I18nLoader.getText("joinGame.input.key.invalid"));
            invalidKeyErrorPopup.displayPopup(errorText);
        }
    }

    private void clearInputFields() {
        this.gameKeyInput.getStyleClass().remove("inputField-error");
        this.gameKeyInput.clear();
    }

    public Pane getRoot() {
        return this.root;
    }
}

