/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient.scenes;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.SceneManager;
import com.battleshipclient.UserOverlay;
import com.battleshipclient.WebSocketClientService;
import com.battleshipclient.status.UserStatus;
import com.battleshipclient.utils.I18nLoader;
import com.battleshipclient.utils.SimpleConfirmationPopup;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class HomeScene {
    private final VBox logout;
    private final WebSocketClientService webSocketService;
    private final VBox account;
    private final Button toCreateGameSceneButton = new Button();
    private final Button toJoinGameSceneButton = new Button();
    private final Pane root;

    public HomeScene(SceneManager sceneManager, WebSocketClientService webSocketService) {
        this.account = this.setAccountBoxParameters(new VBox(20.0), sceneManager);
        this.logout = this.setLogOutBoxParameters(sceneManager);
        this.webSocketService = webSocketService;
        HBox game = this.setGameBoxParameters(new HBox(80.0), sceneManager);
        VBox header = this.setHeaderBoxParameters(new VBox(20.0));
        this.root = this.setScene(header, this.account, this.logout, game);
    }

    @NotNull
    private AnchorPane setScene(VBox header, VBox account, VBox logout, HBox game) {
        AnchorPane anchoredLayout = new AnchorPane();
        anchoredLayout.getChildren().add(this.setBackgroundImage());
        anchoredLayout.getChildren().addAll((Node[])new Node[]{header, account, logout, game});
        AnchorPane.setTopAnchor(header, 20.0);
        AnchorPane.setLeftAnchor(header, 0.0);
        AnchorPane.setRightAnchor(header, 0.0);
        AnchorPane.setTopAnchor(account, 20.0);
        AnchorPane.setRightAnchor(account, 20.0);
        AnchorPane.setTopAnchor(logout, 20.0);
        AnchorPane.setRightAnchor(logout, 20.0);
        AnchorPane.setTopAnchor(game, 400.0);
        AnchorPane.setLeftAnchor(game, 0.0);
        AnchorPane.setRightAnchor(game, 0.0);
        anchoredLayout.prefWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        anchoredLayout.prefHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        anchoredLayout.getStylesheets().add(Objects.requireNonNull(this.getClass().getResource("/assets/ui/home.css")).toExternalForm());
        return anchoredLayout;
    }

    @NotNull
    private ImageView setBackgroundImage() {
        Image backgroundImage = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/HomeScene_Background.jpg")).toExternalForm());
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.fitWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        backgroundView.fitHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        return backgroundView;
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    private VBox setAccountBoxParameters(@NotNull VBox box, SceneManager sceneManager) {
        box.setAlignment(Pos.TOP_RIGHT);
        Button toSignUpSceneButton = new Button(I18nLoader.getText("scene.title.signUp"));
        toSignUpSceneButton.setOnAction(event -> sceneManager.showSignUpScene());
        toSignUpSceneButton.getStyleClass().add("account-button");
        Button toLoginSceneButton = new Button(I18nLoader.getText("scene.title.logIn"));
        toLoginSceneButton.setOnAction(event -> sceneManager.showLoginScene());
        toLoginSceneButton.getStyleClass().add("account-button");
        box.getChildren().addAll((Node[])new Node[]{toLoginSceneButton, toSignUpSceneButton});
        return box;
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    private HBox setGameBoxParameters(@NotNull HBox box, SceneManager sceneManager) {
        box.setAlignment(Pos.CENTER);
        this.toCreateGameSceneButton.setText(I18nLoader.getText("scene.title.createGame"));
        this.toCreateGameSceneButton.setOnAction(event -> {
            sceneManager.showCreateGameScene();
            UserOverlay.showOverlay();
        });
        this.toCreateGameSceneButton.getStyleClass().add("game-button");
        this.toJoinGameSceneButton.setText(I18nLoader.getText("scene.title.joinGame"));
        this.toJoinGameSceneButton.setOnAction(event -> {
            sceneManager.showJoinGameScene();
            UserOverlay.showOverlay();
        });
        this.toJoinGameSceneButton.getStyleClass().add("game-button");
        box.getChildren().addAll((Node[])new Node[]{this.toCreateGameSceneButton, this.toJoinGameSceneButton});
        return box;
    }

    @NotNull
    @Contract(value="_ -> param1")
    private VBox setHeaderBoxParameters(@NotNull VBox box) {
        box.setAlignment(Pos.TOP_CENTER);
        Text title = new Text(I18nLoader.getText("appTitle"));
        title.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 60.0));
        title.setTextAlignment(TextAlignment.CENTER);
        Text credentials = new Text(I18nLoader.getText("appCredentials"));
        credentials.setFont(Font.font("Courier New", FontWeight.BOLD, 20.0));
        credentials.setTextAlignment(TextAlignment.CENTER);
        box.getChildren().addAll((Node[])new Node[]{title, credentials});
        return box;
    }

    @NotNull
    private VBox setLogOutBoxParameters(SceneManager sceneManager) {
        VBox box = new VBox(20.0);
        box.setAlignment(Pos.TOP_RIGHT);
        box.setDisable(true);
        box.setVisible(false);
        Button toLogOutButton = new Button(I18nLoader.getText("scene.title.logOut"));
        toLogOutButton.setOnAction(event -> {
            Text confirmationText = new Text(I18nLoader.getText("logout"));
            SimpleConfirmationPopup confirmationPopup = new SimpleConfirmationPopup();
            confirmationPopup.displayPopup(confirmationText, confirmed -> {
                if (confirmed.booleanValue()) {
                    UserOverlay.initOverlay(false, "");
                    UserOverlay.disableOverlay();
                    sceneManager.showHomeScene(false);
                    UserStatus.setAccessToken(null);
                    this.webSocketService.disconnect();
                }
            });
        });
        toLogOutButton.getStyleClass().add("account-button");
        box.getChildren().add(toLogOutButton);
        return box;
    }

    public Pane getRoot(boolean isLoggedIn) {
        if (isLoggedIn) {
            this.account.setDisable(true);
            this.account.setVisible(false);
            this.logout.setDisable(false);
            this.logout.setVisible(true);
        } else {
            this.toCreateGameSceneButton.setDisable(true);
            this.toJoinGameSceneButton.setDisable(true);
        }
        return this.root;
    }
}

