/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient.scenes;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.ApiService;
import com.battleshipclient.SceneManager;
import com.battleshipclient.UserOverlay;
import com.battleshipclient.WebSocketClientService;
import com.battleshipclient.scenes.PlayGameScene;
import com.battleshipclient.status.GameStatus;
import com.battleshipclient.utils.I18nLoader;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class CreateGameScene {
    private final SceneManager sceneManager;
    @NotNull
    private final WebSocketClientService webSocketService;
    private final Pane root;
    Button toCreateGameButton;
    private TextField gameKeyInput;
    private VBox loadingOverlay;

    public CreateGameScene(SceneManager sceneManager, WebSocketClientService webSocketService) {
        this.sceneManager = sceneManager;
        this.webSocketService = webSocketService;
        VBox header = this.setHeaderBoxParameters(new VBox(20.0));
        VBox keyDisplay = this.setKeyParameter(new VBox(40.0));
        HBox navigation = this.setNavigationButtons(new HBox(40.0), sceneManager);
        this.root = this.setScene(header, keyDisplay, navigation);
        webSocketService.setGameScene(this);
    }

    @NotNull
    private AnchorPane setScene(VBox header, VBox keyDisplay, HBox navigation) {
        AnchorPane anchoredLayout = new AnchorPane();
        anchoredLayout.getChildren().add(this.setBackgroundImage());
        anchoredLayout.getChildren().addAll((Node[])new Node[]{header, keyDisplay, navigation});
        AnchorPane.setTopAnchor(header, 20.0);
        AnchorPane.setLeftAnchor(header, 0.0);
        AnchorPane.setRightAnchor(header, 0.0);
        AnchorPane.setBottomAnchor(navigation, 20.0);
        AnchorPane.setRightAnchor(navigation, 20.0);
        AnchorPane.setLeftAnchor(keyDisplay, 0.0);
        AnchorPane.setRightAnchor(keyDisplay, 0.0);
        AnchorPane.setTopAnchor(keyDisplay, 100.0);
        AnchorPane.setBottomAnchor(keyDisplay, 50.0);
        anchoredLayout.prefWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        anchoredLayout.prefHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        anchoredLayout.getStylesheets().add(Objects.requireNonNull(this.getClass().getResource("/assets/ui/createGame.css")).toExternalForm());
        return anchoredLayout;
    }

    @NotNull
    private ImageView setBackgroundImage() {
        Image backgroundImage = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/PreGameScenes_Background.jpg")).toExternalForm());
        ImageView backgroundView = new ImageView(backgroundImage);
        backgroundView.fitWidthProperty().bind(FXGL.getGameScene().getViewport().widthProperty());
        backgroundView.fitHeightProperty().bind(FXGL.getGameScene().getViewport().heightProperty());
        return backgroundView;
    }

    @NotNull
    @Contract(value="_ -> param1")
    private VBox setHeaderBoxParameters(@NotNull VBox box) {
        box.setAlignment(Pos.TOP_CENTER);
        Text title = new Text(I18nLoader.getText("appTitle"));
        title.setFont(Font.font("Courier New", FontWeight.EXTRA_BOLD, 60.0));
        title.setTextAlignment(TextAlignment.CENTER);
        Text subTitle = new Text(I18nLoader.getText("scene.title.createGame"));
        subTitle.setFont(Font.font("Courier New", FontWeight.BOLD, 40.0));
        subTitle.setTextAlignment(TextAlignment.CENTER);
        box.getChildren().addAll((Node[])new Node[]{title, subTitle});
        return box;
    }

    @NotNull
    private VBox setKeyParameter(@NotNull VBox box) {
        box.setAlignment(Pos.CENTER);
        HBox gameKeyBox = new HBox(20.0);
        gameKeyBox.setAlignment(Pos.CENTER);
        Text gameKeyTitle = new Text(I18nLoader.getText("gameKey.title"));
        gameKeyTitle.setFont(Font.font("Courier New", FontWeight.BOLD, 30.0));
        this.gameKeyInput = new TextField();
        this.gameKeyInput.getStyleClass().add("inputField");
        this.gameKeyInput.setEditable(false);
        gameKeyBox.getChildren().setAll((Node[])new Node[]{gameKeyTitle, this.gameKeyInput});
        box.getChildren().addAll((Node[])new Node[]{gameKeyBox});
        return box;
    }

    @NotNull
    @Contract(value="_, _ -> param1")
    private HBox setNavigationButtons(@NotNull HBox box, SceneManager sceneManager) {
        box.setAlignment(Pos.BOTTOM_RIGHT);
        this.toCreateGameButton = new Button(I18nLoader.getText("create"));
        this.toCreateGameButton.setOnAction(event -> this.createGame());
        this.toCreateGameButton.getStyleClass().add("green-button");
        Button toCancelButton = new Button(I18nLoader.getText("return"));
        toCancelButton.setOnAction(event -> {
            this.toCreateGameButton.setDisable(false);
            sceneManager.showHomeScene(true);
            this.clearInputFields();
            UserOverlay.showOverlay();
            ApiService.abortGame();
        });
        toCancelButton.getStyleClass().add("default-button");
        box.getChildren().addAll((Node[])new Node[]{toCancelButton, this.toCreateGameButton});
        return box;
    }

    private void createGame() {
        ApiService.createGame();
        this.gameKeyInput.setText(GameStatus.getGameKey());
        this.showLoadingOverlay();
        this.toCreateGameButton.setDisable(true);
    }

    public void afterPlayerJoined(String opponentName) {
        FXGL.getGameScene().removeUINode(this.loadingOverlay);
        this.clearInputFields();
        this.toCreateGameButton.setDisable(false);
        GameStatus.setOpponentUserName(opponentName);
        GameStatus.startGame(true);
        PlayGameScene playGame = new PlayGameScene(this.sceneManager, this.webSocketService);
        FXGL.getGameScene().clearUINodes();
        FXGL.getGameScene().addUINode(playGame.getRoot());
    }

    private void showLoadingOverlay() {
        this.loadingOverlay = new VBox(40.0);
        this.loadingOverlay.setAlignment(Pos.CENTER);
        Text waitingForOpponentText = new Text(I18nLoader.getText("waitingForOpponent"));
        waitingForOpponentText.setFont(Font.font("Courier New", FontWeight.BOLD, 30.0));
        waitingForOpponentText.setTextAlignment(TextAlignment.CENTER);
        waitingForOpponentText.getStyleClass().add("yellow-text");
        Image loadingIcon = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/LoadingIcon.png")).toExternalForm());
        ImageView loadingIconView = new ImageView(loadingIcon);
        loadingIconView.setFitHeight(100.0);
        loadingIconView.setFitWidth(100.0);
        this.loadingOverlay.getChildren().setAll((Node[])new Node[]{waitingForOpponentText, loadingIconView});
        this.loadingOverlay.getStylesheets().add(Objects.requireNonNull(this.getClass().getResource("/assets/ui/createGame.css")).toExternalForm());
        this.loadingOverlay.setTranslateX((double)FXGL.getAppWidth() / 2.0 - 175.0);
        this.loadingOverlay.setTranslateY((double)FXGL.getAppHeight() / 2.0 - 220.0);
        FXGL.getGameScene().addUINode(this.loadingOverlay);
    }

    private void clearInputFields() {
        this.gameKeyInput.getStyleClass().remove("inputField-error");
        this.gameKeyInput.clear();
    }

    public Pane getRoot() {
        return this.root;
    }
}

