/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.status.UserStatus;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class UserOverlay {
    private static HBox userOverlay;

    public static void initOverlay(boolean isVisible, String user) {
        if (isVisible && !UserStatus.getIsLoggedIn()) {
            UserStatus.setUsername(user);
            UserStatus.setIsLoggedIn(true);
        } else if (!isVisible && UserStatus.getIsLoggedIn()) {
            UserStatus.setUsername("");
            UserStatus.setIsLoggedIn(false);
        }
    }

    public static void showOverlay() {
        userOverlay = new HBox(10.0);
        userOverlay.setAlignment(Pos.CENTER_LEFT);
        userOverlay.getStyleClass().add("userOverlay");
        userOverlay.setPrefWidth(-1.0);
        userOverlay.setMinWidth(-1.0);
        userOverlay.setMaxWidth(-1.0);
        Text user = new Text(UserStatus.getUsername());
        user.setFont(Font.font("Courier New", FontWeight.BOLD, 30.0));
        user.setTextAlignment(TextAlignment.RIGHT);
        Image icon = new Image(Objects.requireNonNull(UserOverlay.class.getResource("/assets/textures/icons/icon_1.jpg")).toExternalForm());
        ImageView iconView = new ImageView(icon);
        iconView.setFitHeight(50.0);
        iconView.setFitWidth(50.0);
        iconView.setPreserveRatio(true);
        iconView.setSmooth(true);
        iconView.setCache(true);
        Circle clip = new Circle(25.0, 25.0, 25.0);
        iconView.setClip(clip);
        userOverlay.getChildren().addAll((Node[])new Node[]{iconView, user});
        userOverlay.getStylesheets().add(Objects.requireNonNull(UserOverlay.class.getResource("/assets/ui/general.css")).toExternalForm());
        userOverlay.setTranslateX(0.0);
        userOverlay.setTranslateY(0.0);
        FXGL.getGameScene().addUINode(userOverlay);
    }

    public static void disableOverlay() {
        FXGL.getGameScene().removeUINode(userOverlay);
    }
}

