/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient;

import com.battleshipclient.WebSocketClientService;
import com.battleshipclient.records.HitNotification;
import com.battleshipclient.records.Notification;
import com.battleshipclient.status.GameStatus;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import javafx.application.Platform;
import org.jetbrains.annotations.NotNull;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;

public class StompSessionHandler
extends StompSessionHandlerAdapter {
    private final WebSocketClientService webSocketClientService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public StompSessionHandler(WebSocketClientService webSocketClientService) {
        this.webSocketClientService = webSocketClientService;
    }

    @Override
    public void afterConnected(StompSession session, @NotNull StompHeaders connectedHeaders) {
        String destination = "/user/queue/notification";
        System.out.println("Subscribing to " + destination);
        session.subscribe(destination, new StompFrameHandler(){

            @Override
            @NotNull
            public Type getPayloadType(@NotNull StompHeaders headers) {
                return Notification.class;
            }

            @Override
            public void handleFrame(@NotNull StompHeaders headers, Object payload) {
                Notification notification = (Notification)payload;
                System.out.println(payload);
                switch (notification.type()) {
                    case PLAYER_JOINED_GAME: {
                        String opponentName = (String)notification.data();
                        Platform.runLater(() -> StompSessionHandler.this.webSocketClientService.getGameScene().afterPlayerJoined(opponentName));
                        break;
                    }
                    case GAME_READY: {
                        GameStatus.setAllShipsSetOpponent();
                        StompSessionHandler.this.webSocketClientService.getPlayGameScene().setOpponentTurnNotification(GameStatus.getIsMyTurnValue());
                        break;
                    }
                    case GAME_FINISHED: {
                        StompSessionHandler.this.webSocketClientService.getPlayGameScene().handleLose();
                        break;
                    }
                    case OPPONENT_SURRENDERED: {
                        StompSessionHandler.this.webSocketClientService.getPlayGameScene().handleSurrender();
                        break;
                    }
                    case HIT: 
                    case SHIP_DESTROYED: {
                        HitNotification hitNotification = StompSessionHandler.this.objectMapper.convertValue(notification.data(), HitNotification.class);
                        Platform.runLater(() -> StompSessionHandler.this.webSocketClientService.getPlayGameScene().setCrossOnField(hitNotification.x(), hitNotification.y()));
                        break;
                    }
                    case YOUR_TURN: {
                        GameStatus.setIsMyTurn(true);
                    }
                }
            }
        });
    }
}

