/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient;

import com.almasb.fxgl.dsl.FXGL;
import com.battleshipclient.WebSocketClientService;
import com.battleshipclient.scenes.CreateGameScene;
import com.battleshipclient.scenes.HomeScene;
import com.battleshipclient.scenes.JoinGameScene;
import com.battleshipclient.scenes.LoginScene;
import com.battleshipclient.scenes.SignUpScene;
import javafx.scene.layout.Pane;

public class SceneManager {
    private final Pane homeScene;
    private final Pane homeSceneLoggedIn;
    private final Pane createGameScene;
    private final Pane joinGameScene;
    private final Pane loginScene;
    private final Pane signupScene;

    public SceneManager(WebSocketClientService webSocketService) {
        this.homeScene = new HomeScene(this, webSocketService).getRoot(false);
        this.homeSceneLoggedIn = new HomeScene(this, webSocketService).getRoot(true);
        this.createGameScene = new CreateGameScene(this, webSocketService).getRoot();
        this.joinGameScene = new JoinGameScene(this, webSocketService).getRoot();
        this.loginScene = new LoginScene(this, webSocketService).getRoot();
        this.signupScene = new SignUpScene(this, webSocketService).getRoot();
    }

    public void showHomeScene(boolean isLoggedIn) {
        FXGL.getGameScene().clearUINodes();
        if (isLoggedIn) {
            FXGL.getGameScene().addUINode(this.homeSceneLoggedIn);
        } else {
            FXGL.getGameScene().addUINode(this.homeScene);
        }
    }

    public void showCreateGameScene() {
        FXGL.getGameScene().clearUINodes();
        FXGL.getGameScene().addUINode(this.createGameScene);
    }

    public void showJoinGameScene() {
        FXGL.getGameScene().clearUINodes();
        FXGL.getGameScene().addUINode(this.joinGameScene);
    }

    public void showLoginScene() {
        FXGL.getGameScene().clearUINodes();
        FXGL.getGameScene().addUINode(this.loginScene);
    }

    public void showSignUpScene() {
        FXGL.getGameScene().clearUINodes();
        FXGL.getGameScene().addUINode(this.signupScene);
    }
}

