/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient;

import com.almasb.fxgl.app.GameApplication;
import com.almasb.fxgl.app.GameSettings;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.UserAction;
import com.battleshipclient.GameExit;
import com.battleshipclient.SceneManager;
import com.battleshipclient.WebSocketClientService;
import com.battleshipclient.utils.I18nLoader;
import java.util.Objects;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import org.jetbrains.annotations.NotNull;

public class Main
extends GameApplication {
    @Override
    protected void initSettings(@NotNull GameSettings settings) {
        settings.setTitle(I18nLoader.getText("appTitle"));
        settings.setWidth(1440);
        settings.setHeight(810);
        settings.setVersion("1.0");
        settings.setGameMenuEnabled(false);
    }

    @Override
    protected void initGame() {
        Image mouseCursorImage = new Image(Objects.requireNonNull(this.getClass().getResource("/assets/textures/Mouse_Cursor.png")).toExternalForm());
        WebSocketClientService webSocketClientService = new WebSocketClientService();
        FXGL.getGameScene().setCursor(new ImageCursor(mouseCursorImage));
        SceneManager sceneManager = new SceneManager(webSocketClientService);
        sceneManager.showHomeScene(false);
        FXGL.getPrimaryStage().setOnCloseRequest(event -> {
            GameExit exit = new GameExit();
            exit.exit();
            event.consume();
            System.exit(0);
        });
    }

    @Override
    protected void initInput() {
        Input input = FXGL.getInput();
        input.addAction(new UserAction(this, "Exit"){

            @Override
            protected void onActionEnd() {
                super.onActionEnd();
                GameExit exit = new GameExit();
                exit.exit();
            }
        }, KeyCode.ESCAPE);
    }

    public static void main(String[] args2) {
        Main.launch(args2);
    }
}

