/*
 * Decompiled with CFR 0.152.
 */
package com.battleshipclient;

import com.battleshipclient.enums.HitType;
import com.battleshipclient.records.JoinGameResponse;
import com.battleshipclient.records.Ship;
import com.battleshipclient.status.GameStatus;
import com.battleshipclient.status.UserStatus;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;

public class ApiService {
    private static final HttpClient client = HttpClient.newHttpClient();
    private static final String baseUrl = "https://api.bs.sh00ckbass.de";
    private static final Gson gson = new Gson();

    public static void registerUser(String username, String password) {
        String body2 = String.format("{\n    \"username\": \"%s\",\n    \"password\": \"%s\"\n}\n", username, password);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.bs.sh00ckbass.de/auth/register")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body2)).build();
        try {
            client.send(request, HttpResponse.BodyHandlers.ofString());
            ApiService.loginUser(username, password);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void loginUser(String username, String password) {
        String body2 = String.format("{\n    \"username\": \"%s\",\n    \"password\": \"%s\"\n}\n", username, password);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.bs.sh00ckbass.de/auth/login")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body2)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            UserStatus.setAccessToken(response.body());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void createGame() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.bs.sh00ckbass.de/game/create")).header("Content-Type", "application/json").header("Authorization", "Bearer " + UserStatus.getAccessToken()).POST(HttpRequest.BodyPublishers.noBody()).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            GameStatus.setGameKey(response.body());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void joinGame(String gameKey) {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.bs.sh00ckbass.de/game/join")).header("Content-Type", "application/json").header("Authorization", "Bearer " + UserStatus.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(gameKey)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JoinGameResponse joinResponse = gson.fromJson(response.body(), JoinGameResponse.class);
            GameStatus.setOpponentUserName(joinResponse.challengerName());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupBoard(List<Ship> ships) {
        JsonArray shipArray = new JsonArray();
        for (Ship ship : ships) {
            shipArray.add(gson.toJsonTree(ship));
        }
        JsonObject result = new JsonObject();
        result.add("ships", shipArray);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.bs.sh00ckbass.de/game/setup-board")).header("Content-Type", "application/json").header("Authorization", "Bearer " + UserStatus.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(gson.toJson(result))).build();
        try {
            client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void surrender() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.bs.sh00ckbass.de/game/surrender")).header("Content-Type", "application/json").header("Authorization", "Bearer " + UserStatus.getAccessToken()).POST(HttpRequest.BodyPublishers.noBody()).build();
        try {
            client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void hit(int posX, int posY) {
        String body2 = String.format("{\n    \"x\": %d,\n    \"y\": %d\n}\n", posX, posY);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.bs.sh00ckbass.de/game/hit")).header("Content-Type", "application/json").header("Authorization", "Bearer " + UserStatus.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(body2)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = response.body();
            String enumType = responseBody.substring(1, responseBody.length() - 1);
            GameStatus.setCurrentHitType(HitType.valueOf(enumType));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void abortGame() {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.bs.sh00ckbass.de/game/abort")).header("Content-Type", "application/json").header("Authorization", "Bearer " + UserStatus.getAccessToken()).POST(HttpRequest.BodyPublishers.noBody()).build();
        try {
            client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

