/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui.property;

import com.almasb.fxgl.ui.property.PropertyViewFactory;
import javafx.beans.property.ObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;

public class Point2DPropertyViewFactory
implements PropertyViewFactory<Point2D, HBox> {
    private boolean ignoreChangeView = false;
    private boolean ignoreChangeProperty = false;

    @Override
    public HBox makeView(ObjectProperty<Point2D> value) {
        TextField fieldX = new TextField();
        TextField fieldY = new TextField();
        HBox view2 = new HBox(fieldX, fieldY);
        value.addListener((obs, o, newValue) -> {
            if (this.ignoreChangeProperty) {
                return;
            }
            this.onPropertyChanged(value, view2);
        });
        fieldX.textProperty().addListener((obs, o, x) -> {
            if (this.ignoreChangeView) {
                return;
            }
            this.onViewChanged(value, view2);
        });
        fieldY.textProperty().addListener((obs, o, y) -> {
            if (this.ignoreChangeView) {
                return;
            }
            this.onViewChanged(value, view2);
        });
        this.onPropertyChanged(value, view2);
        return view2;
    }

    @Override
    public void onPropertyChanged(ObjectProperty<Point2D> value, HBox view2) {
        TextField fieldX = (TextField)view2.getChildren().get(0);
        TextField fieldY = (TextField)view2.getChildren().get(1);
        this.ignoreChangeView = true;
        fieldX.setText(Double.toString(((Point2D)value.getValue()).getX()));
        fieldY.setText(Double.toString(((Point2D)value.getValue()).getY()));
        this.ignoreChangeView = false;
    }

    @Override
    public void onViewChanged(ObjectProperty<Point2D> value, HBox view2) {
        TextField fieldX = (TextField)view2.getChildren().get(0);
        TextField fieldY = (TextField)view2.getChildren().get(1);
        this.ignoreChangeProperty = true;
        Point2D newPoint = new Point2D(Double.parseDouble(fieldX.getText()), Double.parseDouble(fieldY.getText()));
        value.setValue(newPoint);
        this.ignoreChangeProperty = false;
    }
}

