/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.ui;

import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.ui.Position;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.Timeline;
import javafx.animation.TranslateTransition;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Glow;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public final class ProgressBar
extends Parent {
    private static final Logger log = Logger.get("FXGL.ProgressBar");
    private DoubleProperty minValue = new SimpleDoubleProperty(0.0);
    private DoubleProperty currentValue = new SimpleDoubleProperty(0.0);
    private DoubleProperty maxValue = new SimpleDoubleProperty(100.0);
    private DoubleProperty width = new SimpleDoubleProperty(200.0);
    private DoubleProperty height = new SimpleDoubleProperty(10.0);
    private final Rectangle backgroundBar = new Rectangle();
    private final Rectangle innerBar = new Rectangle();
    private Group barGroup = new Group();
    private Label label = new Label();
    private Position labelPosition = Position.BOTTOM;
    private Paint traceFill = Color.WHITE;
    private Timeline timeline = new Timeline();
    private ChangeListener<Number> update;

    public ProgressBar() {
        this(true);
    }

    public ProgressBar(boolean showChanges) {
        this.innerBar.setTranslateX(5.0);
        this.innerBar.setTranslateY(3.0);
        this.innerBar.setFill(Color.rgb(255, 239, 211));
        this.backgroundBar.widthProperty().bind(this.width);
        this.backgroundBar.heightProperty().bind(this.height);
        this.innerBar.heightProperty().bind(this.height.subtract(6));
        this.backgroundBar.arcWidthProperty().bind(this.width.divide(8));
        this.backgroundBar.arcHeightProperty().bind(this.width.divide(8));
        this.innerBar.arcWidthProperty().bind(this.width.divide(8));
        this.innerBar.arcHeightProperty().bind(this.width.divide(8));
        DropShadow ds = new DropShadow(10.0, Color.WHITE);
        ds.setInput(new Glow(0.3));
        ds.setWidth(50.0);
        this.backgroundBar.setEffect(ds);
        ds = new DropShadow(5.0, Color.GOLD);
        ds.setInput(new Glow(0.1));
        this.innerBar.setEffect(ds);
        this.label.setFont(Font.font(16.0));
        this.label.setTextFill(Color.GOLD);
        this.label.textProperty().bind(this.currentValue.asString("%.0f").concat("/").concat(this.maxValue.asString("%.0f")));
        this.update = (obs, oldValue, newValue) -> {
            if (!showChanges) {
                return;
            }
            double newWidth = (this.width.get() - 10.0) * (this.currentValue.get() - this.minValue.get()) / (this.maxValue.get() - this.minValue.get());
            int diff = newValue.intValue() - oldValue.intValue();
            if (diff != 0) {
                Text text = new Text((diff > 0 ? "+" : "") + diff);
                text.setTranslateX(newWidth + (double)(diff > 0 ? 5 : 25));
                text.setTranslateY(this.height.get() / 2.0);
                text.setFill(this.traceFill);
                text.setFont(Font.font(14.0));
                this.barGroup.getChildren().add(text);
                TranslateTransition tt = new TranslateTransition(Duration.seconds(0.66), text);
                tt.setToY(0.0);
                FadeTransition ft = new FadeTransition(Duration.seconds(0.66), text);
                ft.setToValue(0.0);
                ParallelTransition pt = new ParallelTransition(ft);
                pt.setOnFinished(e -> this.barGroup.getChildren().remove(text));
                pt.play();
            }
            Rectangle trace = new Rectangle(Math.abs(newWidth - this.innerBar.getWidth()), this.height.get() - 6.0);
            trace.setArcWidth(this.innerBar.getArcWidth());
            trace.setArcHeight(this.innerBar.getArcHeight());
            trace.setTranslateX(Math.min(this.innerBar.getWidth(), newWidth));
            trace.setTranslateY(3.0);
            trace.setFill(this.traceFill);
            trace.setOpacity(0.55);
            trace.setEffect(new Glow(0.5));
            if (trace.getWidth() > 50.0) {
                this.barGroup.getChildren().add(trace);
                FadeTransition ft2 = new FadeTransition(Duration.seconds(0.5), trace);
                ft2.setToValue(0.0);
                ft2.setOnFinished(e -> this.barGroup.getChildren().remove(trace));
                ft2.play();
            }
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
            this.timeline.getKeyFrames().add(new KeyFrame(Duration.seconds(0.66), new KeyValue(this.innerBar.widthProperty(), newWidth)));
            this.timeline.play();
        };
        this.currentValue.addListener(this.update);
        this.barGroup.getChildren().addAll((Node[])new Node[]{this.backgroundBar, this.innerBar});
        this.getChildren().addAll((Node[])new Node[]{this.barGroup, this.label});
        this.setLabelPosition(this.labelPosition);
        this.setLabelVisible(false);
        if (!showChanges) {
            this.innerBar.widthProperty().bind(this.width.subtract(10).multiply(new DoubleBinding(){

                @Override
                protected double computeValue() {
                    return (ProgressBar.this.currentValue.get() - ProgressBar.this.minValue.get()) / (ProgressBar.this.maxValue.get() - ProgressBar.this.minValue.get());
                }
            }));
        }
    }

    public Rectangle getBackgroundBar() {
        return this.backgroundBar;
    }

    public Rectangle getInnerBar() {
        return this.innerBar;
    }

    public void setBackgroundFill(Paint color) {
        this.backgroundBar.setFill(color);
    }

    public void setFill(Color color) {
        this.innerBar.setFill(color);
        DropShadow ds = new DropShadow(15.0, color);
        ds.setInput(new Glow(0.5));
        this.innerBar.setEffect(ds);
    }

    public void setLabelFill(Paint color) {
        this.label.setTextFill(color);
    }

    public void setTraceFill(Paint color) {
        this.traceFill = color;
    }

    public void setLabelVisible(boolean b) {
        if (!b) {
            this.getChildren().remove(this.label);
            this.barGroup.translateXProperty().unbind();
            this.barGroup.translateYProperty().unbind();
            this.barGroup.setTranslateX(0.0);
            this.barGroup.setTranslateY(0.0);
        } else if (!this.getChildren().contains(this.label)) {
            this.getChildren().add(this.label);
            this.setLabelPosition(this.labelPosition);
        }
    }

    public boolean isLabelVisible() {
        return this.getChildren().contains(this.label);
    }

    public void setLabelPosition(Position pos) {
        this.labelPosition = pos;
        if (!this.isLabelVisible()) {
            return;
        }
        this.barGroup.translateXProperty().unbind();
        this.barGroup.translateYProperty().unbind();
        this.label.translateXProperty().unbind();
        this.label.translateYProperty().unbind();
        switch (pos) {
            case BOTTOM: {
                this.barGroup.setTranslateX(0.0);
                this.barGroup.setTranslateY(0.0);
                this.label.translateXProperty().bind(this.width.divide(2).subtract(this.label.widthProperty().divide(2)));
                this.label.translateYProperty().bind(this.height);
                break;
            }
            case LEFT: {
                this.barGroup.translateXProperty().bind(this.label.widthProperty().add(10));
                this.barGroup.setTranslateY(0.0);
                this.label.setTranslateX(0.0);
                this.label.translateYProperty().bind(this.height.divide(2).subtract(this.label.heightProperty().divide(2)));
                break;
            }
            case RIGHT: {
                this.barGroup.setTranslateX(0.0);
                this.barGroup.setTranslateY(0.0);
                this.label.translateXProperty().bind(this.width.add(10));
                this.label.translateYProperty().bind(this.height.divide(2).subtract(this.label.heightProperty().divide(2)));
                break;
            }
            case TOP: {
                this.barGroup.setTranslateX(0.0);
                this.barGroup.translateYProperty().bind(this.label.heightProperty());
                this.label.translateXProperty().bind(this.width.divide(2).subtract(this.label.widthProperty().divide(2)));
                this.label.setTranslateY(0.0);
                break;
            }
            default: {
                log.warning("Unknown position: " + String.valueOf((Object)pos));
            }
        }
    }

    public void setWidth(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Width must be > 0");
        }
        this.width.set(value);
        this.update.changed(this.currentValue, this.currentValue.get(), this.currentValue.get());
    }

    public void setHeight(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Height must be > 0");
        }
        this.height.set(value);
    }

    public void setMinValue(double value) {
        if (value > this.currentValue.get()) {
            log.warning("Current value < min value. Setting min value as current");
            this.currentValue.set(value);
        }
        if (value >= this.maxValue.get()) {
            log.warning("Min value >= max value. Setting max value to min value + 1");
            this.maxValue.set(value + 1.0);
        }
        this.minValue.set(value);
    }

    public DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public void setCurrentValue(double value) {
        double newValue = value;
        if (value < this.minValue.get()) {
            log.warning("Current value < min value. Setting min value as current");
            newValue = this.minValue.get();
        } else if (value > this.maxValue.get()) {
            log.warning("Current value > max value. Setting max value as current");
            newValue = this.maxValue.get();
        }
        this.currentValue.set(newValue);
    }

    public double getCurrentValue() {
        return this.currentValue.get();
    }

    public DoubleProperty currentValueProperty() {
        return this.currentValue;
    }

    public void setMaxValue(double value) {
        if (value <= this.minValue.get()) {
            log.warning("Max value <= min value. Setting min value to max value - 1");
            this.minValue.set(value - 1.0);
        }
        if (value < this.currentValue.get()) {
            log.warning("Max value < current value. Setting current value to max");
            this.currentValue.set(value);
        }
        this.maxValue.set(value);
    }

    public DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public static ProgressBar makeHPBar() {
        ProgressBar bar = new ProgressBar();
        bar.setHeight(25.0);
        bar.setFill(Color.GREEN.brighter());
        bar.setTraceFill(Color.GREEN.brighter());
        bar.setLabelVisible(true);
        return bar;
    }

    public static ProgressBar makeSkillBar() {
        ProgressBar bar = new ProgressBar();
        bar.setHeight(25.0);
        bar.setFill(Color.BLUE.brighter().brighter());
        bar.setTraceFill(Color.BLUE);
        bar.setLabelVisible(true);
        return bar;
    }
}

