/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.trade.view;

import com.almasb.fxgl.trade.Shop;
import com.almasb.fxgl.trade.TradeItem;
import com.almasb.fxgl.trade.view.TradeListView;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/almasb/fxgl/trade/view/ShopView;", "T", "Ljavafx/scene/layout/Pane;", "shop", "Lcom/almasb/fxgl/trade/Shop;", "width", "", "height", "(Lcom/almasb/fxgl/trade/Shop;II)V", "box", "Ljavafx/scene/layout/VBox;", "listView", "Lcom/almasb/fxgl/trade/view/TradeListView;", "getListView", "()Lcom/almasb/fxgl/trade/view/TradeListView;", "getShop", "()Lcom/almasb/fxgl/trade/Shop;", "fxgl-gameplay"})
public final class ShopView<T>
extends Pane {
    @NotNull
    private final Shop<T> shop;
    @NotNull
    private final VBox box;
    @NotNull
    private final TradeListView listView;

    public ShopView(@NotNull Shop<T> shop, int width, int height) {
        Intrinsics.checkNotNullParameter(shop, "shop");
        this.shop = shop;
        this.setPrefSize(width, height);
        Rectangle bg = new Rectangle(width, height);
        bg.setFill(Color.rgb(0, 0, 0, 0.6));
        Rectangle lineTop = new Rectangle(width, 4.0);
        lineTop.setFill(Color.rgb(25, 250, 25));
        lineTop.setStroke(Color.BLACK);
        lineTop.setStrokeWidth(1.3);
        Rectangle lineBot = new Rectangle(width, 4.0);
        lineBot.setTranslateY(height - 40 - 2);
        lineBot.setFill(Color.rgb(25, 250, 25));
        lineBot.setStroke(Color.BLACK);
        lineBot.setStrokeWidth(1.3);
        this.box = new VBox(5.0);
        this.box.setTranslateX(25.0);
        this.box.setTranslateY(25.0);
        Text textMoney = new Text();
        textMoney.setFill(Color.YELLOW);
        textMoney.setFont(Font.font(22.0));
        textMoney.textProperty().bind(this.shop.moneyProperty().asString("Money: %d"));
        textMoney.setTranslateX(25.0);
        textMoney.setTranslateY((double)height - (double)10);
        ObservableList<TradeItem<?>> observableList = this.shop.getItems();
        Intrinsics.checkNotNull(observableList, "null cannot be cast to non-null type javafx.collections.ObservableList<com.almasb.fxgl.trade.TradeItem<*>>");
        this.listView = new TradeListView(observableList);
        this.listView.setTranslateX(10.0);
        this.listView.setTranslateY(25.0);
        this.listView.setPrefSize(width - 20, height - 50 - 40);
        Node[] nodeArray = new Node[]{bg, lineTop, lineBot, this.box, this.listView, textMoney};
        this.getChildren().addAll((Node[])nodeArray);
    }

    @NotNull
    public final Shop<T> getShop() {
        return this.shop;
    }

    @NotNull
    public final TradeListView getListView() {
        return this.listView;
    }
}

