/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.time;

import com.almasb.fxgl.core.serialization.Bundle;
import com.almasb.fxgl.time.LocalTimer;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/time/OfflineTimer;", "Lcom/almasb/fxgl/time/LocalTimer;", "name", "", "bundle", "Lcom/almasb/fxgl/core/serialization/Bundle;", "(Ljava/lang/String;Lcom/almasb/fxgl/core/serialization/Bundle;)V", "getName", "()Ljava/lang/String;", "capture", "", "elapsed", "", "duration", "Ljavafx/util/Duration;", "fxgl-core"})
public final class OfflineTimer
implements LocalTimer {
    @NotNull
    private final String name;
    @NotNull
    private final Bundle bundle;

    public OfflineTimer(@NotNull String name, @NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        this.name = name;
        this.bundle = bundle;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public void capture() {
        String string = "offline.timer." + this.name;
        LocalDateTime localDateTime = LocalDateTime.now();
        Intrinsics.checkNotNullExpressionValue(localDateTime, "now()");
        this.bundle.put(string, localDateTime);
    }

    @Override
    public boolean elapsed(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "duration");
        LocalDateTime dateTime = (LocalDateTime)this.bundle.get("offline.timer." + this.name);
        if (dateTime == null) {
            this.capture();
            return true;
        }
        return LocalDateTime.now().minus((long)duration.toMillis(), ChronoUnit.MILLIS).isAfter(dateTime);
    }
}

