/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.core.Copyable;
import com.almasb.fxgl.core.View;
import com.almasb.fxgl.texture.AnimatedTexture;
import com.almasb.fxgl.texture.AnimationChannel;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Pixel;
import com.almasb.fxgl.texture.Texture;
import java.util.List;
import javafx.geometry.HorizontalDirection;
import javafx.geometry.Rectangle2D;
import javafx.geometry.VerticalDirection;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0007\b\u0014\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0000J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\u0006\u0010\u001c\u001a\u00020\u0000J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\tH\u0016J\u001a\u0010\"\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010#\u001a\u00020$H\u0007J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001fJ\u0006\u0010+\u001a\u00020\u0000J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u0000J\u000e\u0010.\u001a\u00020\u00002\u0006\u0010/\u001a\u000200J\u0016\u00101\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\u0016\u00101\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00002\u0006\u00102\u001a\u000204J\u000e\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u0016\u00105\u001a\u0002062\u0006\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u00020\u0000J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010>\u001a\u00020\u0000J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006@"}, d2={"Lcom/almasb/fxgl/texture/Texture;", "Ljavafx/scene/image/ImageView;", "Lcom/almasb/fxgl/core/View;", "Lcom/almasb/fxgl/core/Copyable;", "image", "Ljavafx/scene/image/Image;", "(Ljavafx/scene/image/Image;)V", "()V", "height", "", "getHeight", "()D", "width", "getWidth", "blend", "node", "Ljavafx/scene/Node;", "blendMode", "Ljavafx/scene/effect/BlendMode;", "backgroundImage", "brighter", "copy", "darker", "desaturate", "discolor", "dispose", "", "getNode", "invert", "multiplyColor", "color", "Ljavafx/scene/paint/Color;", "onUpdate", "tpf", "outline", "offset", "", "pixels", "", "Lcom/almasb/fxgl/texture/Pixel;", "replaceColor", "oldColor", "newColor", "saturate", "set", "other", "subTexture", "area", "Ljavafx/geometry/Rectangle2D;", "superTexture", "direction", "Ljavafx/geometry/HorizontalDirection;", "Ljavafx/geometry/VerticalDirection;", "toAnimatedTexture", "Lcom/almasb/fxgl/texture/AnimatedTexture;", "defaultChannel", "Lcom/almasb/fxgl/texture/AnimationChannel;", "frames", "duration", "Ljavafx/util/Duration;", "toBlackWhite", "toColor", "toGrayscale", "transparentColor", "fxgl-core"})
public class Texture
extends ImageView
implements View,
Copyable<Texture> {
    public Texture(@NotNull Image image2) {
        Intrinsics.checkNotNullParameter(image2, "image");
        super(image2);
    }

    protected Texture() {
    }

    public final double getWidth() {
        return this.getImage().getWidth();
    }

    public final double getHeight() {
        return this.getImage().getHeight();
    }

    @NotNull
    public final AnimatedTexture toAnimatedTexture(int frames, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "duration");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return this.toAnimatedTexture(new AnimationChannel(image2, duration, frames));
    }

    @NotNull
    public final AnimatedTexture toAnimatedTexture(@NotNull AnimationChannel defaultChannel) {
        Intrinsics.checkNotNullParameter(defaultChannel, "defaultChannel");
        return new AnimatedTexture(defaultChannel);
    }

    @Override
    @NotNull
    public Texture copy() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(image2);
    }

    @NotNull
    public final Texture subTexture(@NotNull Rectangle2D area) {
        Intrinsics.checkNotNullParameter(area, "area");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.subImage(image2, area));
    }

    @NotNull
    public final Texture superTexture(@NotNull Texture other, @NotNull HorizontalDirection direction) {
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Image leftImage = null;
        Image rightImage = null;
        if (direction == HorizontalDirection.LEFT) {
            Image image2 = other.getImage();
            Intrinsics.checkNotNullExpressionValue(image2, "other.image");
            leftImage = image2;
            Image image3 = this.getImage();
            Intrinsics.checkNotNullExpressionValue(image3, "this.image");
            rightImage = image3;
        } else {
            Image image4 = this.getImage();
            Intrinsics.checkNotNullExpressionValue(image4, "this.image");
            leftImage = image4;
            Image image5 = other.getImage();
            Intrinsics.checkNotNullExpressionValue(image5, "other.image");
            rightImage = image5;
        }
        int width = (int)(leftImage.getWidth() + rightImage.getWidth());
        int height = (int)Math.max(leftImage.getHeight(), rightImage.getHeight());
        PixelReader leftReader = leftImage.getPixelReader();
        PixelReader rightReader = rightImage.getPixelReader();
        WritableImage image6 = new WritableImage(width, height);
        PixelWriter pixelWriter = image6.getPixelWriter();
        pixelWriter.setPixels(0, 0, (int)leftImage.getWidth(), (int)leftImage.getHeight(), leftReader, 0, 0);
        pixelWriter.setPixels((int)leftImage.getWidth(), 0, (int)rightImage.getWidth(), (int)rightImage.getHeight(), rightReader, 0, 0);
        return new Texture(image6);
    }

    @NotNull
    public final Texture superTexture(@NotNull Texture other, @NotNull VerticalDirection direction) {
        Intrinsics.checkNotNullParameter(other, "other");
        Intrinsics.checkNotNullParameter((Object)direction, "direction");
        Image topImage = null;
        Image bottomImage = null;
        if (direction == VerticalDirection.DOWN) {
            Image image2 = this.getImage();
            Intrinsics.checkNotNullExpressionValue(image2, "this.image");
            topImage = image2;
            Image image3 = other.getImage();
            Intrinsics.checkNotNullExpressionValue(image3, "other.image");
            bottomImage = image3;
        } else {
            Image image4 = other.getImage();
            Intrinsics.checkNotNullExpressionValue(image4, "other.image");
            topImage = image4;
            Image image5 = this.getImage();
            Intrinsics.checkNotNullExpressionValue(image5, "this.image");
            bottomImage = image5;
        }
        int width = (int)Math.max(topImage.getWidth(), bottomImage.getWidth());
        int height = (int)(topImage.getHeight() + bottomImage.getHeight());
        PixelReader topReader = topImage.getPixelReader();
        PixelReader bottomReader = bottomImage.getPixelReader();
        WritableImage image6 = new WritableImage(width, height);
        PixelWriter pixelWriter = image6.getPixelWriter();
        pixelWriter.setPixels(0, 0, (int)topImage.getWidth(), (int)topImage.getHeight(), topReader, 0, 0);
        pixelWriter.setPixels(0, (int)topImage.getHeight(), (int)bottomImage.getWidth(), (int)bottomImage.getHeight(), bottomReader, 0, 0);
        return new Texture(image6);
    }

    @NotNull
    public final List<Pixel> pixels() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return ImagesKt.toPixels(image2);
    }

    @NotNull
    public final Texture toGrayscale() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, toGrayscale.1.INSTANCE));
    }

    @NotNull
    public final Texture toBlackWhite() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, toBlackWhite.1.INSTANCE));
    }

    @NotNull
    public final Texture invert() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, invert.1.INSTANCE));
    }

    @NotNull
    public final Texture brighter() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, brighter.1.INSTANCE));
    }

    @NotNull
    public final Texture darker() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, darker.1.INSTANCE));
    }

    @NotNull
    public final Texture saturate() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, saturate.1.INSTANCE));
    }

    @NotNull
    public final Texture desaturate() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, desaturate.1.INSTANCE));
    }

    @NotNull
    public final Texture discolor() {
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, discolor.1.INSTANCE));
    }

    @NotNull
    public final Texture multiplyColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)new Function1<Pixel, Pixel>(color){
            final /* synthetic */ Color $color;
            {
                this.$color = $color;
                super(1);
            }

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Color color = Color.color(it.getR() * this.$color.getRed(), it.getG() * this.$color.getGreen(), it.getB() * this.$color.getBlue(), it.getA() * this.$color.getOpacity());
                Intrinsics.checkNotNullExpressionValue(color, "color(\n                i\u2026* color.opacity\n        )");
                return it.copy(color);
            }
        }));
    }

    @NotNull
    public final Texture toColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        Texture discolored = this.discolor();
        Texture colored = discolored.multiplyColor(color);
        discolored.dispose();
        return colored;
    }

    @NotNull
    public final Texture replaceColor(@NotNull Color oldColor, @NotNull Color newColor) {
        Intrinsics.checkNotNullParameter(oldColor, "oldColor");
        Intrinsics.checkNotNullParameter(newColor, "newColor");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        Image newImage2 = ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)new Function1<Pixel, Pixel>(oldColor, newColor){
            final /* synthetic */ Color $oldColor;
            final /* synthetic */ Color $newColor;
            {
                this.$oldColor = $oldColor;
                this.$newColor = $newColor;
                super(1);
            }

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Color c = Intrinsics.areEqual(it.getColor(), this.$oldColor) ? this.$newColor : it.getColor();
                return it.copy(c);
            }
        });
        return new Texture(newImage2);
    }

    @NotNull
    public final Texture transparentColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        Color color2 = Color.TRANSPARENT;
        Intrinsics.checkNotNullExpressionValue(color2, "TRANSPARENT");
        return this.replaceColor(color, color2);
    }

    @NotNull
    public final Texture blend(@NotNull Node node, @NotNull BlendMode blendMode) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter((Object)blendMode, "blendMode");
        return this.blend(ImagesKt.toImage(node), blendMode);
    }

    @NotNull
    public final Texture blend(@NotNull Image backgroundImage, @NotNull BlendMode blendMode) {
        Intrinsics.checkNotNullParameter(backgroundImage, "backgroundImage");
        Intrinsics.checkNotNullParameter((Object)blendMode, "blendMode");
        Image image2 = this.getImage();
        Intrinsics.checkNotNullExpressionValue(image2, "image");
        return new Texture(ImagesKt.map(backgroundImage, image2, ImagesKt.operation(blendMode)));
    }

    @JvmOverloads
    @NotNull
    public final Texture outline(@NotNull Color color, int offset) {
        Texture coloredTexture;
        Intrinsics.checkNotNullParameter(color, "color");
        Group view2 = new Group();
        Texture outline1 = coloredTexture = this.toColor(color);
        outline1.setTranslateX(offset);
        Texture outline2 = coloredTexture.copy();
        outline2.setTranslateX(-((double)offset));
        Texture outline3 = coloredTexture.copy();
        outline3.setTranslateY(offset);
        Texture outline4 = coloredTexture.copy();
        outline4.setTranslateY(-((double)offset));
        Node[] nodeArray = new Node[]{outline1, outline2, outline3, outline4, this.copy()};
        view2.getChildren().addAll((Node[])nodeArray);
        return new Texture(ImagesKt.toImage(view2));
    }

    public static /* synthetic */ Texture outline$default(Texture texture, Color color, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: outline");
        }
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return texture.outline(color, n);
    }

    public final void set(@NotNull Texture other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.setFitWidth(other.getFitWidth());
        this.setFitHeight(other.getFitHeight());
        this.setImage(other.getImage());
    }

    @Override
    public void onUpdate(double tpf) {
    }

    @Override
    @NotNull
    public Node getNode() {
        return this;
    }

    @Override
    public void dispose() {
        this.setImage(null);
    }

    @JvmOverloads
    @NotNull
    public final Texture outline(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        return Texture.outline$default(this, color, 0, 2, null);
    }
}

