/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.texture;

import com.almasb.fxgl.animation.AnimatedImage;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.texture.ImagesKt;
import com.almasb.fxgl.texture.Pixel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.image.WritablePixelFormat;
import javafx.scene.paint.Color;
import javax.imageio.ImageIO;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000l\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u000e\u0010+\u001a\u00020&2\u0006\u0010%\u001a\u00020&\u001a\u000e\u0010,\u001a\u00020&2\u0006\u0010%\u001a\u00020&\u001a\u000e\u0010-\u001a\u00020&2\u0006\u0010%\u001a\u00020&\u001a$\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u000203\u001a\u0006\u00104\u001a\u00020&\u001a\"\u00105\u001a\b\u0012\u0004\u0012\u00020&032\f\u00106\u001a\b\u0012\u0004\u0012\u00020&032\u0006\u00107\u001a\u000200\u001a\u0014\u00108\u001a\u00020&2\f\u00106\u001a\b\u0012\u0004\u0012\u00020&03\u001a(\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<2\u0006\u0010>\u001a\u00020<2\u0006\u0010?\u001a\u00020<H\u0002\u001a\u001e\u0010@\u001a\u00020&2\u0006\u0010%\u001a\u00020&2\u0006\u0010A\u001a\u0002002\u0006\u0010B\u001a\u000200\u001a&\u0010@\u001a\u00020&2\u0006\u0010%\u001a\u00020&2\u0006\u0010A\u001a\u0002002\u0006\u0010B\u001a\u0002002\u0006\u0010C\u001a\u00020D\u001a\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020&\u001a\u000e\u0010H\u001a\u00020&2\u0006\u0010I\u001a\u00020J\u001a\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020\u0002032\u0006\u0010%\u001a\u00020&\u001a\u0016\u0010L\u001a\u00020D2\u0006\u0010%\u001a\u00020&2\u0006\u0010M\u001a\u00020N\u001a\u001a\u0010O\u001a\u00020\u0002*\u00020&2\u0006\u0010P\u001a\u0002002\u0006\u0010Q\u001a\u000200\u001a\u001e\u0010R\u001a\u00020&*\u00020&2\u0012\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020T\u001a,\u0010R\u001a\u00020&*\u00020&2\u0006\u0010U\u001a\u00020&2\u0018\u0010S\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u001c\u0010V\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001*\u00020W\u001a\n\u0010X\u001a\u00020<*\u00020:\u001a\u0012\u0010Y\u001a\u00020&*\u00020&2\u0006\u0010Z\u001a\u00020[\u001a\n\u0010H\u001a\u00020&*\u00020\\\"&\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"&\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"&\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\"&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\"&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0004\"&\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0004\"&\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0004\"&\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0004\"&\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0004\"&\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0004\"&\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0004\"&\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0004\"&\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0004\"&\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0004\"&\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0004\"&\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0004\"&\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0004\"\u001b\u0010%\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(\u00a8\u0006]"}, d2={"ADD_BLEND", "Lkotlin/Function2;", "Lcom/almasb/fxgl/texture/Pixel;", "getADD_BLEND", "()Lkotlin/jvm/functions/Function2;", "BLUE_BLEND", "getBLUE_BLEND", "COLOR_BURN_BLEND", "getCOLOR_BURN_BLEND", "COLOR_DODGE_BLEND", "getCOLOR_DODGE_BLEND", "DARKEN_BLEND", "getDARKEN_BLEND", "DIFFERENCE_BLEND", "getDIFFERENCE_BLEND", "EXCLUSION_BLEND", "getEXCLUSION_BLEND", "GREEN_BLEND", "getGREEN_BLEND", "HARD_LIGHT_BLEND", "getHARD_LIGHT_BLEND", "LIGHTEN_BLEND", "getLIGHTEN_BLEND", "MULTIPLY_BLEND", "getMULTIPLY_BLEND", "OVERLAY_BLEND", "getOVERLAY_BLEND", "RED_BLEND", "getRED_BLEND", "SCREEN_BLEND", "getSCREEN_BLEND", "SOFT_LIGHT_BLEND", "getSOFT_LIGHT_BLEND", "SRC_ATOP_BLEND", "getSRC_ATOP_BLEND", "SRC_OVER_BLEND", "getSRC_OVER_BLEND", "image", "Ljavafx/scene/image/Image;", "getImage", "()Ljavafx/scene/image/Image;", "image$delegate", "Lkotlin/Lazy;", "flipDiagonally", "flipHorizontally", "flipVertically", "fromPixels", "width", "", "height", "pixels", "", "getDummyImage", "interpolateIntermediateImages", "images", "numFramesBetweenImages", "merge", "newColor", "Ljavafx/scene/paint/Color;", "r", "", "g", "b", "a", "resize", "targetWidth", "targetHeight", "isPreserveRatio", "", "toBufferedImage", "Ljava/awt/image/BufferedImage;", "fxImage", "toImage", "node", "Ljavafx/scene/Node;", "toPixels", "writeToFile", "filePath", "Ljava/nio/file/Path;", "getPixel", "x", "y", "map", "f", "Lkotlin/Function1;", "overlay", "operation", "Ljavafx/scene/effect/BlendMode;", "rgbSum", "subImage", "area", "Ljavafx/geometry/Rectangle2D;", "", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nImages.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Images.kt\ncom/almasb/fxgl/texture/ImagesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,682:1\n2976#2,5:683\n1549#2:688\n1620#2,3:689\n1855#2,2:692\n1549#2:699\n1620#2,3:700\n1855#2,2:703\n1#3:694\n11345#4:695\n11680#4,3:696\n*S KotlinDebug\n*F\n+ 1 Images.kt\ncom/almasb/fxgl/texture/ImagesKt\n*L\n104#1:683,5\n105#1:688\n105#1:689,3\n111#1:692,2\n620#1:699\n620#1:700,3\n665#1:703,2\n619#1:695\n619#1:696,3\n*E\n"})
public final class ImagesKt {
    @NotNull
    private static final Lazy image$delegate = LazyKt.lazy(image.2.INSTANCE);
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> SRC_OVER_BLEND = SRC_OVER_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> SRC_ATOP_BLEND = SRC_ATOP_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> ADD_BLEND = ADD_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> MULTIPLY_BLEND = MULTIPLY_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> SCREEN_BLEND = SCREEN_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> OVERLAY_BLEND = OVERLAY_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> DARKEN_BLEND = DARKEN_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> LIGHTEN_BLEND = LIGHTEN_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> COLOR_DODGE_BLEND = COLOR_DODGE_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> COLOR_BURN_BLEND = COLOR_BURN_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> HARD_LIGHT_BLEND = HARD_LIGHT_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> SOFT_LIGHT_BLEND = SOFT_LIGHT_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> DIFFERENCE_BLEND = DIFFERENCE_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> EXCLUSION_BLEND = EXCLUSION_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> RED_BLEND = RED_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> GREEN_BLEND = GREEN_BLEND.1.INSTANCE;
    @NotNull
    private static final Function2<Pixel, Pixel, Pixel> BLUE_BLEND = BLUE_BLEND.1.INSTANCE;

    private static final Image getImage() {
        Lazy lazy = image$delegate;
        return (Image)lazy.getValue();
    }

    @NotNull
    public static final Image getDummyImage() {
        return ImagesKt.getImage();
    }

    @NotNull
    public static final Image toImage(@NotNull Node node) {
        Intrinsics.checkNotNullParameter(node, "node");
        WritableImage writableImage = Async.INSTANCE.startAsyncFX(() -> ImagesKt.toImage$lambda$0(node)).await();
        Intrinsics.checkNotNullExpressionValue(writableImage, "Async.startAsyncFX(Calla\u2026(params, null)\n}).await()");
        return writableImage;
    }

    @NotNull
    public static final List<Pixel> toPixels(@NotNull Image image2) {
        Intrinsics.checkNotNullParameter(image2, "image");
        ArrayList<Pixel> result = new ArrayList<Pixel>();
        ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)new Function1<Pixel, Pixel>(result){
            final /* synthetic */ ArrayList<Pixel> $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkNotNullParameter(it, "it");
                ((Collection)this.$result).add(it);
                return it;
            }
        });
        return result;
    }

    @NotNull
    public static final Image fromPixels(int width, int height, @NotNull List<Pixel> pixels) {
        Intrinsics.checkNotNullParameter(pixels, "pixels");
        WritableImage image2 = new WritableImage(width, height);
        int index = 0;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                image2.getPixelWriter().setColor(x, y, pixels.get(index++).getColor());
            }
        }
        return image2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Image merge(@NotNull List<? extends Image> images) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(images, "images");
        if (images.isEmpty()) {
            return ImagesKt.getDummyImage();
        }
        if (images.size() == 1) {
            return CollectionsKt.first(images);
        }
        Iterable $this$sumBy$iv = images;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv2 : $this$sumBy$iv) {
            void it;
            Image image2 = (Image)element$iv2;
            int n = sum$iv;
            boolean bl = false;
            int n2 = (int)it.getWidth();
            sum$iv = n + n2;
        }
        int width = sum$iv;
        Iterable $this$map$iv = images;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Image image3 = (Image)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)it.getHeight());
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((List)destination$iv$iv);
        int height = n != null ? n : 0;
        WritableImage image4 = new WritableImage(width, height);
        int dstX = 0;
        Iterable $this$forEach$iv = images;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            Image it = (Image)element$iv3;
            boolean bl = false;
            int w = (int)it.getWidth();
            int h = (int)it.getHeight();
            image4.getPixelWriter().setPixels(dstX, 0, w, h, it.getPixelReader(), 0, 0);
            dstX += w;
        }
        return image4;
    }

    @NotNull
    public static final Image resize(@NotNull Image image2, int targetWidth, int targetHeight) {
        Intrinsics.checkNotNullParameter(image2, "image");
        return ImagesKt.resize(image2, targetWidth, targetHeight, false);
    }

    @NotNull
    public static final Image resize(@NotNull Image image2, int targetWidth, int targetHeight, boolean isPreserveRatio) {
        Intrinsics.checkNotNullParameter(image2, "image");
        int width = (int)image2.getWidth();
        int height = (int)image2.getHeight();
        double scaleHorizontal = (double)width / (double)targetWidth;
        double scaleVertical = (double)height / (double)targetHeight;
        if (isPreserveRatio) {
            scaleVertical = scaleHorizontal;
        }
        WritableImage output = new WritableImage(targetWidth, targetHeight);
        PixelReader reader = image2.getPixelReader();
        PixelWriter writer = output.getPixelWriter();
        for (int y = 0; y < targetHeight; ++y) {
            for (int x = 0; x < targetWidth; ++x) {
                int argb = reader.getArgb((int)((double)x * scaleHorizontal), (int)((double)y * scaleVertical));
                writer.setArgb(x, y, argb);
            }
        }
        return output;
    }

    @NotNull
    public static final Image flipHorizontally(@NotNull Image image2) {
        Intrinsics.checkNotNullParameter(image2, "image");
        int maxX = (int)image2.getWidth() - 1;
        return ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)new Function1<Pixel, Pixel>(maxX, image2){
            final /* synthetic */ int $maxX;
            final /* synthetic */ Image $image;
            {
                this.$maxX = $maxX;
                this.$image = $image;
                super(1);
            }

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkNotNullParameter(it, "it");
                int srcX = this.$maxX - it.getX();
                int srcY = it.getY();
                Color color = this.$image.getPixelReader().getColor(srcX, srcY);
                Intrinsics.checkNotNullExpressionValue(color, "color");
                return it.copy(color);
            }
        });
    }

    @NotNull
    public static final Image flipVertically(@NotNull Image image2) {
        Intrinsics.checkNotNullParameter(image2, "image");
        int maxY = (int)image2.getHeight() - 1;
        return ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)new Function1<Pixel, Pixel>(maxY, image2){
            final /* synthetic */ int $maxY;
            final /* synthetic */ Image $image;
            {
                this.$maxY = $maxY;
                this.$image = $image;
                super(1);
            }

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkNotNullParameter(it, "it");
                int srcX = it.getX();
                int srcY = this.$maxY - it.getY();
                Color color = this.$image.getPixelReader().getColor(srcX, srcY);
                Intrinsics.checkNotNullExpressionValue(color, "color");
                return it.copy(color);
            }
        });
    }

    @NotNull
    public static final Image flipDiagonally(@NotNull Image image2) {
        Intrinsics.checkNotNullParameter(image2, "image");
        int maxX = (int)image2.getWidth() - 1;
        int maxY = (int)image2.getHeight() - 1;
        return ImagesKt.map(image2, (Function1<? super Pixel, Pixel>)new Function1<Pixel, Pixel>(maxX, maxY, image2){
            final /* synthetic */ int $maxX;
            final /* synthetic */ int $maxY;
            final /* synthetic */ Image $image;
            {
                this.$maxX = $maxX;
                this.$maxY = $maxY;
                this.$image = $image;
                super(1);
            }

            @NotNull
            public final Pixel invoke(@NotNull Pixel it) {
                Intrinsics.checkNotNullParameter(it, "it");
                int srcX = this.$maxX - it.getX();
                int srcY = this.$maxY - it.getY();
                Color color = this.$image.getPixelReader().getColor(srcX, srcY);
                Intrinsics.checkNotNullExpressionValue(color, "color");
                return it.copy(color);
            }
        });
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> operation(@NotNull BlendMode $this$operation) {
        Intrinsics.checkNotNullParameter((Object)$this$operation, "<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$operation.ordinal()]) {
            case 1 -> SRC_OVER_BLEND;
            case 2 -> SRC_ATOP_BLEND;
            case 3 -> ADD_BLEND;
            case 4 -> MULTIPLY_BLEND;
            case 5 -> SCREEN_BLEND;
            case 6 -> OVERLAY_BLEND;
            case 7 -> DARKEN_BLEND;
            case 8 -> LIGHTEN_BLEND;
            case 9 -> COLOR_DODGE_BLEND;
            case 10 -> COLOR_BURN_BLEND;
            case 11 -> HARD_LIGHT_BLEND;
            case 12 -> SOFT_LIGHT_BLEND;
            case 13 -> DIFFERENCE_BLEND;
            case 14 -> EXCLUSION_BLEND;
            case 15 -> RED_BLEND;
            case 16 -> GREEN_BLEND;
            case 17 -> BLUE_BLEND;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getSRC_OVER_BLEND() {
        return SRC_OVER_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getSRC_ATOP_BLEND() {
        return SRC_ATOP_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getADD_BLEND() {
        return ADD_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getMULTIPLY_BLEND() {
        return MULTIPLY_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getSCREEN_BLEND() {
        return SCREEN_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getOVERLAY_BLEND() {
        return OVERLAY_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getDARKEN_BLEND() {
        return DARKEN_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getLIGHTEN_BLEND() {
        return LIGHTEN_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getCOLOR_DODGE_BLEND() {
        return COLOR_DODGE_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getCOLOR_BURN_BLEND() {
        return COLOR_BURN_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getHARD_LIGHT_BLEND() {
        return HARD_LIGHT_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getSOFT_LIGHT_BLEND() {
        return SOFT_LIGHT_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getDIFFERENCE_BLEND() {
        return DIFFERENCE_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getEXCLUSION_BLEND() {
        return EXCLUSION_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getRED_BLEND() {
        return RED_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getGREEN_BLEND() {
        return GREEN_BLEND;
    }

    @NotNull
    public static final Function2<Pixel, Pixel, Pixel> getBLUE_BLEND() {
        return BLUE_BLEND;
    }

    private static final Color newColor(double r, double g, double b, double a) {
        Color color = Color.color(Math.max(0.0, Math.min(1.0, r)), Math.max(0.0, Math.min(1.0, g)), Math.max(0.0, Math.min(1.0, b)), Math.max(0.0, Math.min(1.0, a)));
        Intrinsics.checkNotNullExpressionValue(color, "color(\n            max(0\u2026x(0.0, min(1.0, a))\n    )");
        return color;
    }

    @NotNull
    public static final Pixel getPixel(@NotNull Image $this$getPixel, int x, int y) {
        Intrinsics.checkNotNullParameter($this$getPixel, "<this>");
        Color color = $this$getPixel.getPixelReader().getColor(x, y);
        Intrinsics.checkNotNullExpressionValue(color, "this.pixelReader.getColor(x, y)");
        return new Pixel(x, y, color, $this$getPixel);
    }

    @NotNull
    public static final Image map(@NotNull Image $this$map, @NotNull Function1<? super Pixel, Pixel> f) {
        Intrinsics.checkNotNullParameter($this$map, "<this>");
        Intrinsics.checkNotNullParameter(f, "f");
        int w = (int)$this$map.getWidth();
        int h = (int)$this$map.getHeight();
        PixelReader reader = $this$map.getPixelReader();
        WritableImage newImage2 = new WritableImage(w, h);
        PixelWriter writer = newImage2.getPixelWriter();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color color = reader.getColor(x, y);
                Intrinsics.checkNotNullExpressionValue(color, "reader.getColor(x, y)");
                Pixel pixel = new Pixel(x, y, color, $this$map);
                Pixel newPixel = f.invoke(pixel);
                writer.setColor(x, y, newPixel.getColor());
            }
        }
        return newImage2;
    }

    @NotNull
    public static final Image map(@NotNull Image $this$map, @NotNull Image overlay, @NotNull Function2<? super Pixel, ? super Pixel, Pixel> f) {
        Intrinsics.checkNotNullParameter($this$map, "<this>");
        Intrinsics.checkNotNullParameter(overlay, "overlay");
        Intrinsics.checkNotNullParameter(f, "f");
        int w = (int)$this$map.getWidth();
        int h = (int)$this$map.getHeight();
        PixelReader reader = $this$map.getPixelReader();
        PixelReader overlayReader = overlay.getPixelReader();
        WritableImage newImage2 = new WritableImage(w, h);
        PixelWriter writer = newImage2.getPixelWriter();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                Color color = reader.getColor(x, y);
                Intrinsics.checkNotNullExpressionValue(color, "reader.getColor(x, y)");
                Pixel pixel1 = new Pixel(x, y, color, $this$map);
                Color color2 = overlayReader.getColor(x, y);
                Intrinsics.checkNotNullExpressionValue(color2, "overlayReader.getColor(x, y)");
                Pixel pixel2 = new Pixel(x, y, color2, overlay);
                Pixel newPixel = f.invoke(pixel1, pixel2);
                writer.setColor(x, y, newPixel.getColor());
            }
        }
        return newImage2;
    }

    @NotNull
    public static final Image subImage(@NotNull Image $this$subImage, @NotNull Rectangle2D area) {
        Intrinsics.checkNotNullParameter($this$subImage, "<this>");
        Intrinsics.checkNotNullParameter(area, "area");
        int minX = (int)area.getMinX();
        int minY = (int)area.getMinY();
        int maxX = (int)area.getMaxX();
        int maxY = (int)area.getMaxY();
        if (!(minX >= 0)) {
            boolean $i$a$-require-ImagesKt$subImage$52 = false;
            String $i$a$-require-ImagesKt$subImage$52 = "minX value of sub-image cannot be negative";
            throw new IllegalArgumentException($i$a$-require-ImagesKt$subImage$52.toString());
        }
        if (!(minY >= 0)) {
            boolean $i$a$-require-ImagesKt$subImage$62 = false;
            String $i$a$-require-ImagesKt$subImage$62 = "minY value of sub-image cannot be negative";
            throw new IllegalArgumentException($i$a$-require-ImagesKt$subImage$62.toString());
        }
        if (!((double)maxX <= $this$subImage.getWidth())) {
            boolean $i$a$-require-ImagesKt$subImage$72 = false;
            String $i$a$-require-ImagesKt$subImage$72 = "maxX value (" + maxX + ") of sub-image cannot be greater than image width (" + $this$subImage.getWidth() + ")";
            throw new IllegalArgumentException($i$a$-require-ImagesKt$subImage$72.toString());
        }
        if (!((double)maxY <= $this$subImage.getHeight())) {
            boolean $i$a$-require-ImagesKt$subImage$82 = false;
            String $i$a$-require-ImagesKt$subImage$82 = "maxY value (" + maxY + ") of sub-image cannot be greater than image height (" + $this$subImage.getHeight() + ")";
            throw new IllegalArgumentException($i$a$-require-ImagesKt$subImage$82.toString());
        }
        PixelReader pixelReader = $this$subImage.getPixelReader();
        WritableImage newImage2 = new WritableImage(maxX - minX, maxY - minY);
        newImage2.getPixelWriter().setPixels(0, 0, (int)newImage2.getWidth(), (int)newImage2.getHeight(), pixelReader, minX, minY);
        return newImage2;
    }

    public static final double rgbSum(@NotNull Color $this$rgbSum) {
        Intrinsics.checkNotNullParameter($this$rgbSum, "<this>");
        return $this$rgbSum.getRed() + $this$rgbSum.getGreen() + $this$rgbSum.getBlue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Image toImage(@NotNull byte[] $this$toImage) {
        Collection<Pixel> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter($this$toImage, "<this>");
        WritableImage parent = new WritableImage(2, 2);
        byte[] byArray = $this$toImage;
        int n = 38;
        int n2 = 39;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n3 = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n3; ++j) {
            void it;
            void item$iv$iv2;
            void var10_15 = item$iv$iv2 = $this$mapTo$iv$iv[j];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Pixel)((Object)(it == false ? Color.BLACK : Color.WHITE)));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Color item$iv$iv2 = (Color)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            collection.add(new Pixel(0, 0, (Color)it, parent));
        }
        collection = (List)destination$iv$iv;
        return ImagesKt.fromPixels(n2, n, collection);
    }

    @NotNull
    public static final BufferedImage toBufferedImage(@NotNull Image fxImage) {
        Intrinsics.checkNotNullParameter(fxImage, "fxImage");
        int w = (int)fxImage.getWidth();
        int h = (int)fxImage.getHeight();
        BufferedImage awtImage = new BufferedImage(w, h, 3);
        DataBuffer dataBuffer = awtImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull(dataBuffer, "null cannot be cast to non-null type java.awt.image.DataBufferInt");
        DataBufferInt buffer = (DataBufferInt)dataBuffer;
        fxImage.getPixelReader().getPixels(0, 0, w, h, WritablePixelFormat.getIntArgbPreInstance(), buffer.getData(), 0, w);
        return awtImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean writeToFile(@NotNull Image image2, @NotNull Path filePath) {
        Intrinsics.checkNotNullParameter(image2, "image");
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        try {
            Closeable closeable = Files.newOutputStream(filePath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                boolean bl2 = ImageIO.write((RenderedImage)ImagesKt.toBufferedImage(image2), "png", it);
                return bl2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            Logger.Companion.get("Images.kt").warning("failed to save", e);
            return false;
        }
    }

    @NotNull
    public static final List<Image> interpolateIntermediateImages(@NotNull List<? extends Image> images, int numFramesBetweenImages) {
        Intrinsics.checkNotNullParameter(images, "images");
        if (images.size() < 2) {
            return new ArrayList(images);
        }
        ArrayList result = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)images);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Image img1 = (Image)pair.component1();
            Image img2 = (Image)pair.component2();
            AnimatedImage anim = new AnimatedImage(img1, img2);
            ((Collection)result).add(img1);
            int n = 0;
            while (n < numFramesBetweenImages) {
                int i2 = n++;
                boolean bl2 = false;
                ((Collection)result).add(anim.getValue((double)(i2 + 1) / ((double)numFramesBetweenImages + 1.0)));
            }
        }
        ((Collection)result).add(CollectionsKt.last(images));
        return result;
    }

    private static final WritableImage toImage$lambda$0(Node $node) {
        Intrinsics.checkNotNullParameter($node, "$node");
        SnapshotParameters params = new SnapshotParameters();
        params.setFill(Color.TRANSPARENT);
        return $node.snapshot(params, null);
    }

    public static final /* synthetic */ Color access$newColor(double r, double g, double b, double a) {
        return ImagesKt.newColor(r, g, b, a);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlendMode.values().length];
            try {
                nArray[BlendMode.SRC_OVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.SRC_ATOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.ADD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.MULTIPLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.SCREEN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.OVERLAY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.DARKEN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.LIGHTEN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.COLOR_DODGE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.COLOR_BURN.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.HARD_LIGHT.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.SOFT_LIGHT.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.DIFFERENCE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.EXCLUSION.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.RED.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.GREEN.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlendMode.BLUE.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

